/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to get a milestone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMilestoneRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<GetMilestoneRequest.Builder, GetMilestoneRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(GetMilestoneRequest::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()).build();

    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(GetMilestoneRequest::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MilestoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_NUMBER_FIELD));

    private final String workloadId;

    private final Integer milestoneNumber;

    private GetMilestoneRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMilestoneRequest)) {
            return false;
        }
        GetMilestoneRequest other = (GetMilestoneRequest) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(milestoneNumber(), other.milestoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMilestoneRequest").add("WorkloadId", workloadId()).add("MilestoneNumber", milestoneNumber())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMilestoneRequest, T> g) {
        return obj -> g.apply((GetMilestoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMilestoneRequest> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadId;

        private Integer milestoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMilestoneRequest model) {
            super(model);
            workloadId(model.workloadId);
            milestoneNumber(model.milestoneNumber);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMilestoneRequest build() {
            return new GetMilestoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
