/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.PermissionType;
import software.amazon.awssdk.services.wellarchitected.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadShare
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadShare> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareId").getter(WorkloadShare.getter(WorkloadShare::shareId)).setter(WorkloadShare.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()}).build();
    private static final SdkField<String> SHARED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedBy").getter(WorkloadShare.getter(WorkloadShare::sharedBy)).setter(WorkloadShare.setter(Builder::sharedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedBy").build()}).build();
    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedWith").getter(WorkloadShare.getter(WorkloadShare::sharedWith)).setter(WorkloadShare.setter(Builder::sharedWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(WorkloadShare.getter(WorkloadShare::permissionTypeAsString)).setter(WorkloadShare.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(WorkloadShare.getter(WorkloadShare::statusAsString)).setter(WorkloadShare.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(WorkloadShare.getter(WorkloadShare::workloadName)).setter(WorkloadShare.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(WorkloadShare.getter(WorkloadShare::workloadId)).setter(WorkloadShare.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, SHARED_BY_FIELD, SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, STATUS_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shareId;
    private final String sharedBy;
    private final String sharedWith;
    private final String permissionType;
    private final String status;
    private final String workloadName;
    private final String workloadId;

    private WorkloadShare(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.sharedBy = builder.sharedBy;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.status = builder.status;
        this.workloadName = builder.workloadName;
        this.workloadId = builder.workloadId;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final String sharedBy() {
        return this.sharedBy;
    }

    public final String sharedWith() {
        return this.sharedWith;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadShare)) {
            return false;
        }
        WorkloadShare other = (WorkloadShare)obj;
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.sharedBy(), other.sharedBy()) && Objects.equals(this.sharedWith(), other.sharedWith()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.workloadId(), other.workloadId());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadShare").add("ShareId", (Object)this.shareId()).add("SharedBy", (Object)this.sharedBy()).add("SharedWith", (Object)this.sharedWith()).add("PermissionType", (Object)this.permissionTypeAsString()).add("Status", (Object)this.statusAsString()).add("WorkloadName", (Object)this.workloadName()).add("WorkloadId", (Object)this.workloadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "SharedBy": {
                return Optional.ofNullable(clazz.cast(this.sharedBy()));
            }
            case "SharedWith": {
                return Optional.ofNullable(clazz.cast(this.sharedWith()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadShare, T> g) {
        return obj -> g.apply((WorkloadShare)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareId;
        private String sharedBy;
        private String sharedWith;
        private String permissionType;
        private String status;
        private String workloadName;
        private String workloadId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadShare model) {
            this.shareId(model.shareId);
            this.sharedBy(model.sharedBy);
            this.sharedWith(model.sharedWith);
            this.permissionType(model.permissionType);
            this.status(model.status);
            this.workloadName(model.workloadName);
            this.workloadId(model.workloadId);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getSharedBy() {
            return this.sharedBy;
        }

        public final void setSharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
        }

        @Override
        public final Builder sharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
            return this;
        }

        public final String getSharedWith() {
            return this.sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public WorkloadShare build() {
            return new WorkloadShare(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadShare> {
        public Builder shareId(String var1);

        public Builder sharedBy(String var1);

        public Builder sharedWith(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder workloadName(String var1);

        public Builder workloadId(String var1);
    }
}

