/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an update to replace the configuration in an existing identity source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateConfiguration.Builder, UpdateConfiguration> {
    private static final SdkField<UpdateCognitoUserPoolConfiguration> COGNITO_USER_POOL_CONFIGURATION_FIELD = SdkField
            .<UpdateCognitoUserPoolConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cognitoUserPoolConfiguration")
            .getter(getter(UpdateConfiguration::cognitoUserPoolConfiguration))
            .setter(setter(Builder::cognitoUserPoolConfiguration))
            .constructor(UpdateCognitoUserPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoUserPoolConfiguration")
                    .build()).build();

    private static final SdkField<UpdateOpenIdConnectConfiguration> OPEN_ID_CONNECT_CONFIGURATION_FIELD = SdkField
            .<UpdateOpenIdConnectConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("openIdConnectConfiguration")
            .getter(getter(UpdateConfiguration::openIdConnectConfiguration))
            .setter(setter(Builder::openIdConnectConfiguration))
            .constructor(UpdateOpenIdConnectConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIdConnectConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COGNITO_USER_POOL_CONFIGURATION_FIELD, OPEN_ID_CONNECT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration;

    private final UpdateOpenIdConnectConfiguration openIdConnectConfiguration;

    private final Type type;

    private UpdateConfiguration(BuilderImpl builder) {
        this.cognitoUserPoolConfiguration = builder.cognitoUserPoolConfiguration;
        this.openIdConnectConfiguration = builder.openIdConnectConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details of a Amazon Cognito user pool.
     * </p>
     * 
     * @return Contains configuration details of a Amazon Cognito user pool.
     */
    public final UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration() {
        return cognitoUserPoolConfiguration;
    }

    /**
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * 
     * @return Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *         Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *         URL, token type that you want to use, and policy store entity details.
     */
    public final UpdateOpenIdConnectConfiguration openIdConnectConfiguration() {
        return openIdConnectConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cognitoUserPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openIdConnectConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguration)) {
            return false;
        }
        UpdateConfiguration other = (UpdateConfiguration) obj;
        return Objects.equals(cognitoUserPoolConfiguration(), other.cognitoUserPoolConfiguration())
                && Objects.equals(openIdConnectConfiguration(), other.openIdConnectConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfiguration").add("CognitoUserPoolConfiguration", cognitoUserPoolConfiguration())
                .add("OpenIdConnectConfiguration", openIdConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cognitoUserPoolConfiguration":
            return Optional.ofNullable(clazz.cast(cognitoUserPoolConfiguration()));
        case "openIdConnectConfiguration":
            return Optional.ofNullable(clazz.cast(openIdConnectConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool.
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool.
     */
    public static UpdateConfiguration fromCognitoUserPoolConfiguration(
            UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration) {
        return builder().cognitoUserPoolConfiguration(cognitoUserPoolConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool.
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool.
     */
    public static UpdateConfiguration fromCognitoUserPoolConfiguration(
            Consumer<UpdateCognitoUserPoolConfiguration.Builder> cognitoUserPoolConfiguration) {
        UpdateCognitoUserPoolConfiguration.Builder builder = UpdateCognitoUserPoolConfiguration.builder();
        cognitoUserPoolConfiguration.accept(builder);
        return fromCognitoUserPoolConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #openIdConnectConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * 
     * @param openIdConnectConfiguration
     *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *        Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *        URL, token type that you want to use, and policy store entity details.
     */
    public static UpdateConfiguration fromOpenIdConnectConfiguration(UpdateOpenIdConnectConfiguration openIdConnectConfiguration) {
        return builder().openIdConnectConfiguration(openIdConnectConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #openIdConnectConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * 
     * @param openIdConnectConfiguration
     *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *        Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *        URL, token type that you want to use, and policy store entity details.
     */
    public static UpdateConfiguration fromOpenIdConnectConfiguration(
            Consumer<UpdateOpenIdConnectConfiguration.Builder> openIdConnectConfiguration) {
        UpdateOpenIdConnectConfiguration.Builder builder = UpdateOpenIdConnectConfiguration.builder();
        openIdConnectConfiguration.accept(builder);
        return fromOpenIdConnectConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cognitoUserPoolConfiguration", COGNITO_USER_POOL_CONFIGURATION_FIELD);
        map.put("openIdConnectConfiguration", OPEN_ID_CONNECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguration, T> g) {
        return obj -> g.apply((UpdateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateConfiguration> {
        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool.
         * </p>
         * 
         * @param cognitoUserPoolConfiguration
         *        Contains configuration details of a Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoUserPoolConfiguration(UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration);

        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateCognitoUserPoolConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateCognitoUserPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCognitoUserPoolConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cognitoUserPoolConfiguration(UpdateCognitoUserPoolConfiguration)}.
         * 
         * @param cognitoUserPoolConfiguration
         *        a consumer that will call methods on {@link UpdateCognitoUserPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoUserPoolConfiguration(UpdateCognitoUserPoolConfiguration)
         */
        default Builder cognitoUserPoolConfiguration(
                Consumer<UpdateCognitoUserPoolConfiguration.Builder> cognitoUserPoolConfiguration) {
            return cognitoUserPoolConfiguration(UpdateCognitoUserPoolConfiguration.builder()
                    .applyMutation(cognitoUserPoolConfiguration).build());
        }

        /**
         * <p>
         * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         * Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL,
         * token type that you want to use, and policy store entity details.
         * </p>
         * 
         * @param openIdConnectConfiguration
         *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         *        Verified Permissions can use to generate entities from authenticated identities. It specifies the
         *        issuer URL, token type that you want to use, and policy store entity details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectConfiguration(UpdateOpenIdConnectConfiguration openIdConnectConfiguration);

        /**
         * <p>
         * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         * Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL,
         * token type that you want to use, and policy store entity details.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateOpenIdConnectConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateOpenIdConnectConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateOpenIdConnectConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openIdConnectConfiguration(UpdateOpenIdConnectConfiguration)}.
         * 
         * @param openIdConnectConfiguration
         *        a consumer that will call methods on {@link UpdateOpenIdConnectConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIdConnectConfiguration(UpdateOpenIdConnectConfiguration)
         */
        default Builder openIdConnectConfiguration(Consumer<UpdateOpenIdConnectConfiguration.Builder> openIdConnectConfiguration) {
            return openIdConnectConfiguration(UpdateOpenIdConnectConfiguration.builder()
                    .applyMutation(openIdConnectConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration;

        private UpdateOpenIdConnectConfiguration openIdConnectConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguration model) {
            cognitoUserPoolConfiguration(model.cognitoUserPoolConfiguration);
            openIdConnectConfiguration(model.openIdConnectConfiguration);
        }

        public final UpdateCognitoUserPoolConfiguration.Builder getCognitoUserPoolConfiguration() {
            return cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.toBuilder() : null;
        }

        public final void setCognitoUserPoolConfiguration(
                UpdateCognitoUserPoolConfiguration.BuilderImpl cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.build()
                    : null;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
        }

        @Override
        public final Builder cognitoUserPoolConfiguration(UpdateCognitoUserPoolConfiguration cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
            return this;
        }

        public final UpdateOpenIdConnectConfiguration.Builder getOpenIdConnectConfiguration() {
            return openIdConnectConfiguration != null ? openIdConnectConfiguration.toBuilder() : null;
        }

        public final void setOpenIdConnectConfiguration(UpdateOpenIdConnectConfiguration.BuilderImpl openIdConnectConfiguration) {
            Object oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration != null ? openIdConnectConfiguration.build() : null;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
        }

        @Override
        public final Builder openIdConnectConfiguration(UpdateOpenIdConnectConfiguration openIdConnectConfiguration) {
            Object oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
            return this;
        }

        @Override
        public UpdateConfiguration build() {
            return new UpdateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateConfiguration#type()
     */
    public enum Type {
        COGNITO_USER_POOL_CONFIGURATION,

        OPEN_ID_CONNECT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
