/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyStoreResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<GetPolicyStoreResponse.Builder, GetPolicyStoreResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(GetPolicyStoreResponse::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetPolicyStoreResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ValidationSettings> VALIDATION_SETTINGS_FIELD = SdkField
            .<ValidationSettings> builder(MarshallingType.SDK_POJO).memberName("validationSettings")
            .getter(getter(GetPolicyStoreResponse::validationSettings)).setter(setter(Builder::validationSettings))
            .constructor(ValidationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationSettings").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(GetPolicyStoreResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(GetPolicyStoreResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetPolicyStoreResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DELETION_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deletionProtection").getter(getter(GetPolicyStoreResponse::deletionProtectionAsString))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final SdkField<String> CEDAR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cedarVersion").getter(getter(GetPolicyStoreResponse::cedarVersionAsString))
            .setter(setter(Builder::cedarVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cedarVersion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetPolicyStoreResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            ARN_FIELD, VALIDATION_SETTINGS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, DESCRIPTION_FIELD,
            DELETION_PROTECTION_FIELD, CEDAR_VERSION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String arn;

    private final ValidationSettings validationSettings;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private final String description;

    private final String deletionProtection;

    private final String cedarVersion;

    private final Map<String, String> tags;

    private GetPolicyStoreResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.arn = builder.arn;
        this.validationSettings = builder.validationSettings;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.description = builder.description;
        this.deletionProtection = builder.deletionProtection;
        this.cedarVersion = builder.cedarVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the policy store;
     * </p>
     * 
     * @return The ID of the policy store;
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy store.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current validation settings for the policy store.
     * </p>
     * 
     * @return The current validation settings for the policy store.
     */
    public final ValidationSettings validationSettings() {
        return validationSettings;
    }

    /**
     * <p>
     * The date and time that the policy store was originally created.
     * </p>
     * 
     * @return The date and time that the policy store was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time that the policy store was last updated.
     * </p>
     * 
     * @return The date and time that the policy store was last updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * Descriptive text that you can provide to help with identification of the current policy store.
     * </p>
     * 
     * @return Descriptive text that you can provide to help with identification of the current policy store.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
     * </p>
     * <p>
     * The default state is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtection} will return {@link DeletionProtection#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deletionProtectionAsString}.
     * </p>
     * 
     * @return Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.</p>
     *         <p>
     *         The default state is <code>DISABLED</code>.
     * @see DeletionProtection
     */
    public final DeletionProtection deletionProtection() {
        return DeletionProtection.fromValue(deletionProtection);
    }

    /**
     * <p>
     * Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
     * </p>
     * <p>
     * The default state is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtection} will return {@link DeletionProtection#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deletionProtectionAsString}.
     * </p>
     * 
     * @return Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.</p>
     *         <p>
     *         The default state is <code>DISABLED</code>.
     * @see DeletionProtection
     */
    public final String deletionProtectionAsString() {
        return deletionProtection;
    }

    /**
     * <p>
     * The version of the Cedar language used with policies, policy templates, and schemas in this policy store. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
     * Permissions upgrade to Cedar v4 FAQ</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cedarVersion} will
     * return {@link CedarVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cedarVersionAsString}.
     * </p>
     * 
     * @return The version of the Cedar language used with policies, policy templates, and schemas in this policy store.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
     *         Permissions upgrade to Cedar v4 FAQ</a>.
     * @see CedarVersion
     */
    public final CedarVersion cedarVersion() {
        return CedarVersion.fromValue(cedarVersion);
    }

    /**
     * <p>
     * The version of the Cedar language used with policies, policy templates, and schemas in this policy store. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
     * Permissions upgrade to Cedar v4 FAQ</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cedarVersion} will
     * return {@link CedarVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cedarVersionAsString}.
     * </p>
     * 
     * @return The version of the Cedar language used with policies, policy templates, and schemas in this policy store.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
     *         Permissions upgrade to Cedar v4 FAQ</a>.
     * @see CedarVersion
     */
    public final String cedarVersionAsString() {
        return cedarVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tags associated with the policy store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags associated with the policy store.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(validationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cedarVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyStoreResponse)) {
            return false;
        }
        GetPolicyStoreResponse other = (GetPolicyStoreResponse) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(validationSettings(), other.validationSettings())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(description(), other.description())
                && Objects.equals(deletionProtectionAsString(), other.deletionProtectionAsString())
                && Objects.equals(cedarVersionAsString(), other.cedarVersionAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPolicyStoreResponse").add("PolicyStoreId", policyStoreId()).add("Arn", arn())
                .add("ValidationSettings", validationSettings()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DeletionProtection", deletionProtectionAsString()).add("CedarVersion", cedarVersionAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "validationSettings":
            return Optional.ofNullable(clazz.cast(validationSettings()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtectionAsString()));
        case "cedarVersion":
            return Optional.ofNullable(clazz.cast(cedarVersionAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("validationSettings", VALIDATION_SETTINGS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("cedarVersion", CEDAR_VERSION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyStoreResponse, T> g) {
        return obj -> g.apply((GetPolicyStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPolicyStoreResponse> {
        /**
         * <p>
         * The ID of the policy store;
         * </p>
         * 
         * @param policyStoreId
         *        The ID of the policy store;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy store.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current validation settings for the policy store.
         * </p>
         * 
         * @param validationSettings
         *        The current validation settings for the policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSettings(ValidationSettings validationSettings);

        /**
         * <p>
         * The current validation settings for the policy store.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationSettings.Builder} avoiding the
         * need to create one manually via {@link ValidationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #validationSettings(ValidationSettings)}.
         * 
         * @param validationSettings
         *        a consumer that will call methods on {@link ValidationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSettings(ValidationSettings)
         */
        default Builder validationSettings(Consumer<ValidationSettings.Builder> validationSettings) {
            return validationSettings(ValidationSettings.builder().applyMutation(validationSettings).build());
        }

        /**
         * <p>
         * The date and time that the policy store was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the policy store was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date and time that the policy store was last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time that the policy store was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * Descriptive text that you can provide to help with identification of the current policy store.
         * </p>
         * 
         * @param description
         *        Descriptive text that you can provide to help with identification of the current policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
         * </p>
         * <p>
         * The default state is <code>DISABLED</code>.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.</p>
         *        <p>
         *        The default state is <code>DISABLED</code>.
         * @see DeletionProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtection
         */
        Builder deletionProtection(String deletionProtection);

        /**
         * <p>
         * Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
         * </p>
         * <p>
         * The default state is <code>DISABLED</code>.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.</p>
         *        <p>
         *        The default state is <code>DISABLED</code>.
         * @see DeletionProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtection
         */
        Builder deletionProtection(DeletionProtection deletionProtection);

        /**
         * <p>
         * The version of the Cedar language used with policies, policy templates, and schemas in this policy store. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
         * Permissions upgrade to Cedar v4 FAQ</a>.
         * </p>
         * 
         * @param cedarVersion
         *        The version of the Cedar language used with policies, policy templates, and schemas in this policy
         *        store. For more information, see <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon
         *        Verified Permissions upgrade to Cedar v4 FAQ</a>.
         * @see CedarVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CedarVersion
         */
        Builder cedarVersion(String cedarVersion);

        /**
         * <p>
         * The version of the Cedar language used with policies, policy templates, and schemas in this policy store. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon Verified
         * Permissions upgrade to Cedar v4 FAQ</a>.
         * </p>
         * 
         * @param cedarVersion
         *        The version of the Cedar language used with policies, policy templates, and schemas in this policy
         *        store. For more information, see <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/cedar4-faq.html">Amazon
         *        Verified Permissions upgrade to Cedar v4 FAQ</a>.
         * @see CedarVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CedarVersion
         */
        Builder cedarVersion(CedarVersion cedarVersion);

        /**
         * <p>
         * The list of tags associated with the policy store.
         * </p>
         * 
         * @param tags
         *        The list of tags associated with the policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private String policyStoreId;

        private String arn;

        private ValidationSettings validationSettings;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private String description;

        private String deletionProtection;

        private String cedarVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyStoreResponse model) {
            super(model);
            policyStoreId(model.policyStoreId);
            arn(model.arn);
            validationSettings(model.validationSettings);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            description(model.description);
            deletionProtection(model.deletionProtection);
            cedarVersion(model.cedarVersion);
            tags(model.tags);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ValidationSettings.Builder getValidationSettings() {
            return validationSettings != null ? validationSettings.toBuilder() : null;
        }

        public final void setValidationSettings(ValidationSettings.BuilderImpl validationSettings) {
            this.validationSettings = validationSettings != null ? validationSettings.build() : null;
        }

        @Override
        public final Builder validationSettings(ValidationSettings validationSettings) {
            this.validationSettings = validationSettings;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public final Builder deletionProtection(DeletionProtection deletionProtection) {
            this.deletionProtection(deletionProtection == null ? null : deletionProtection.toString());
            return this;
        }

        public final String getCedarVersion() {
            return cedarVersion;
        }

        public final void setCedarVersion(String cedarVersion) {
            this.cedarVersion = cedarVersion;
        }

        @Override
        public final Builder cedarVersion(String cedarVersion) {
            this.cedarVersion = cedarVersion;
            return this;
        }

        @Override
        public final Builder cedarVersion(CedarVersion cedarVersion) {
            this.cedarVersion(cedarVersion == null ? null : cedarVersion.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetPolicyStoreResponse build() {
            return new GetPolicyStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
