/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the list of entities to be considered during an authorization request. This includes all principals,
 * resources, and actions required to successfully evaluate the request.
 * </p>
 * <p>
 * This data type is used as a field in the response parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a> and
 * <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">
 * IsAuthorizedWithToken</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitiesDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<EntitiesDefinition.Builder, EntitiesDefinition> {
    private static final SdkField<List<EntityItem>> ENTITY_LIST_FIELD = SdkField
            .<List<EntityItem>> builder(MarshallingType.LIST)
            .memberName("entityList")
            .getter(getter(EntitiesDefinition::entityList))
            .setter(setter(Builder::entityList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CEDAR_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cedarJson").getter(getter(EntitiesDefinition::cedarJson)).setter(setter(Builder::cedarJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cedarJson").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_LIST_FIELD,
            CEDAR_JSON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EntityItem> entityList;

    private final String cedarJson;

    private final Type type;

    private EntitiesDefinition(BuilderImpl builder) {
        this.entityList = builder.entityList;
        this.cedarJson = builder.cedarJson;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityList() {
        return entityList != null && !(entityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of entities that are needed to successfully evaluate an authorization request. Each entity in this array
     * must include an identifier for the entity, the attributes of the entity, and a list of any parent entities.
     * </p>
     * <note>
     * <p>
     * If you include multiple entities with the same <code>identifier</code>, only the last one is processed in the
     * request.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityList} method.
     * </p>
     * 
     * @return An array of entities that are needed to successfully evaluate an authorization request. Each entity in
     *         this array must include an identifier for the entity, the attributes of the entity, and a list of any
     *         parent entities.</p> <note>
     *         <p>
     *         If you include multiple entities with the same <code>identifier</code>, only the last one is processed in
     *         the request.
     *         </p>
     */
    public final List<EntityItem> entityList() {
        return entityList;
    }

    /**
     * <p>
     * A Cedar JSON string representation of the entities needed to successfully evaluate an authorization request.
     * </p>
     * <p>
     * Example:
     * <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
     * </p>
     * 
     * @return A Cedar JSON string representation of the entities needed to successfully evaluate an authorization
     *         request.</p>
     *         <p>
     *         Example:
     *         <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
     */
    public final String cedarJson() {
        return cedarJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityList() ? entityList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cedarJson());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitiesDefinition)) {
            return false;
        }
        EntitiesDefinition other = (EntitiesDefinition) obj;
        return hasEntityList() == other.hasEntityList() && Objects.equals(entityList(), other.entityList())
                && Objects.equals(cedarJson(), other.cedarJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitiesDefinition").add("EntityList", hasEntityList() ? entityList() : null)
                .add("CedarJson", cedarJson() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityList":
            return Optional.ofNullable(clazz.cast(entityList()));
        case "cedarJson":
            return Optional.ofNullable(clazz.cast(cedarJson()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #entityList()} initialized to the given value.
     *
     * <p>
     * An array of entities that are needed to successfully evaluate an authorization request. Each entity in this array
     * must include an identifier for the entity, the attributes of the entity, and a list of any parent entities.
     * </p>
     * <note>
     * <p>
     * If you include multiple entities with the same <code>identifier</code>, only the last one is processed in the
     * request.
     * </p>
     * </note>
     * 
     * @param entityList
     *        An array of entities that are needed to successfully evaluate an authorization request. Each entity in
     *        this array must include an identifier for the entity, the attributes of the entity, and a list of any
     *        parent entities.</p> <note>
     *        <p>
     *        If you include multiple entities with the same <code>identifier</code>, only the last one is processed in
     *        the request.
     *        </p>
     */
    public static EntitiesDefinition fromEntityList(List<EntityItem> entityList) {
        return builder().entityList(entityList).build();
    }

    /**
     * Create an instance of this class with {@link #cedarJson()} initialized to the given value.
     *
     * <p>
     * A Cedar JSON string representation of the entities needed to successfully evaluate an authorization request.
     * </p>
     * <p>
     * Example:
     * <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
     * </p>
     * 
     * @param cedarJson
     *        A Cedar JSON string representation of the entities needed to successfully evaluate an authorization
     *        request.</p>
     *        <p>
     *        Example:
     *        <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
     */
    public static EntitiesDefinition fromCedarJson(String cedarJson) {
        return builder().cedarJson(cedarJson).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityList", ENTITY_LIST_FIELD);
        map.put("cedarJson", CEDAR_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitiesDefinition, T> g) {
        return obj -> g.apply((EntitiesDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitiesDefinition> {
        /**
         * <p>
         * An array of entities that are needed to successfully evaluate an authorization request. Each entity in this
         * array must include an identifier for the entity, the attributes of the entity, and a list of any parent
         * entities.
         * </p>
         * <note>
         * <p>
         * If you include multiple entities with the same <code>identifier</code>, only the last one is processed in the
         * request.
         * </p>
         * </note>
         * 
         * @param entityList
         *        An array of entities that are needed to successfully evaluate an authorization request. Each entity in
         *        this array must include an identifier for the entity, the attributes of the entity, and a list of any
         *        parent entities.</p> <note>
         *        <p>
         *        If you include multiple entities with the same <code>identifier</code>, only the last one is processed
         *        in the request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(Collection<EntityItem> entityList);

        /**
         * <p>
         * An array of entities that are needed to successfully evaluate an authorization request. Each entity in this
         * array must include an identifier for the entity, the attributes of the entity, and a list of any parent
         * entities.
         * </p>
         * <note>
         * <p>
         * If you include multiple entities with the same <code>identifier</code>, only the last one is processed in the
         * request.
         * </p>
         * </note>
         * 
         * @param entityList
         *        An array of entities that are needed to successfully evaluate an authorization request. Each entity in
         *        this array must include an identifier for the entity, the attributes of the entity, and a list of any
         *        parent entities.</p> <note>
         *        <p>
         *        If you include multiple entities with the same <code>identifier</code>, only the last one is processed
         *        in the request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(EntityItem... entityList);

        /**
         * <p>
         * An array of entities that are needed to successfully evaluate an authorization request. Each entity in this
         * array must include an identifier for the entity, the attributes of the entity, and a list of any parent
         * entities.
         * </p>
         * <note>
         * <p>
         * If you include multiple entities with the same <code>identifier</code>, only the last one is processed in the
         * request.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EntityItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EntityItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EntityItem.Builder#build()} is called
         * immediately and its result is passed to {@link #entityList(List<EntityItem>)}.
         * 
         * @param entityList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.EntityItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityList(java.util.Collection<EntityItem>)
         */
        Builder entityList(Consumer<EntityItem.Builder>... entityList);

        /**
         * <p>
         * A Cedar JSON string representation of the entities needed to successfully evaluate an authorization request.
         * </p>
         * <p>
         * Example:
         * <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
         * </p>
         * 
         * @param cedarJson
         *        A Cedar JSON string representation of the entities needed to successfully evaluate an authorization
         *        request.</p>
         *        <p>
         *        Example:
         *        <code>{"cedarJson": "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cedarJson(String cedarJson);
    }

    static final class BuilderImpl implements Builder {
        private List<EntityItem> entityList = DefaultSdkAutoConstructList.getInstance();

        private String cedarJson;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntitiesDefinition model) {
            entityList(model.entityList);
            cedarJson(model.cedarJson);
        }

        public final List<EntityItem.Builder> getEntityList() {
            List<EntityItem.Builder> result = EntityListCopier.copyToBuilder(this.entityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityList(Collection<EntityItem.BuilderImpl> entityList) {
            Object oldValue = this.entityList;
            this.entityList = EntityListCopier.copyFromBuilder(entityList);
            handleUnionValueChange(Type.ENTITY_LIST, oldValue, this.entityList);
        }

        @Override
        public final Builder entityList(Collection<EntityItem> entityList) {
            Object oldValue = this.entityList;
            this.entityList = EntityListCopier.copy(entityList);
            handleUnionValueChange(Type.ENTITY_LIST, oldValue, this.entityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(EntityItem... entityList) {
            entityList(Arrays.asList(entityList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(Consumer<EntityItem.Builder>... entityList) {
            entityList(Stream.of(entityList).map(c -> EntityItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCedarJson() {
            return cedarJson;
        }

        public final void setCedarJson(String cedarJson) {
            Object oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
        }

        @Override
        public final Builder cedarJson(String cedarJson) {
            Object oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
            return this;
        }

        @Override
        public EntitiesDefinition build() {
            return new EntitiesDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EntitiesDefinition#type()
     */
    public enum Type {
        ENTITY_LIST,

        CEDAR_JSON,

        UNKNOWN_TO_SDK_VERSION
    }
}
