/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSchemaResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<PutSchemaResponse.Builder, PutSchemaResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(PutSchemaResponse::policyStoreId)).setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("namespaces")
            .getter(getter(PutSchemaResponse::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(PutSchemaResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(PutSchemaResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            NAMESPACES_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final List<String> namespaces;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private PutSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.namespaces = builder.namespaces;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    /**
     * <p>
     * The unique ID of the policy store that contains the schema.
     * </p>
     * 
     * @return The unique ID of the policy store that contains the schema.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespaces() {
        return namespaces != null && !(namespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the namespaces of the entities referenced by this schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespaces} method.
     * </p>
     * 
     * @return Identifies the namespaces of the entities referenced by this schema.
     */
    public final List<String> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * The date and time that the schema was originally created.
     * </p>
     * 
     * @return The date and time that the schema was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time that the schema was last updated.
     * </p>
     * 
     * @return The date and time that the schema was last updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespaces() ? namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSchemaResponse)) {
            return false;
        }
        PutSchemaResponse other = (PutSchemaResponse) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && hasNamespaces() == other.hasNamespaces()
                && Objects.equals(namespaces(), other.namespaces()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSchemaResponse").add("PolicyStoreId", policyStoreId())
                .add("Namespaces", namespaces() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedDate", createdDate()).add("LastUpdatedDate", lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSchemaResponse, T> g) {
        return obj -> g.apply((PutSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSchemaResponse> {
        /**
         * <p>
         * The unique ID of the policy store that contains the schema.
         * </p>
         * 
         * @param policyStoreId
         *        The unique ID of the policy store that contains the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Identifies the namespaces of the entities referenced by this schema.
         * </p>
         * 
         * @param namespaces
         *        Identifies the namespaces of the entities referenced by this schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<String> namespaces);

        /**
         * <p>
         * Identifies the namespaces of the entities referenced by this schema.
         * </p>
         * 
         * @param namespaces
         *        Identifies the namespaces of the entities referenced by this schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(String... namespaces);

        /**
         * <p>
         * The date and time that the schema was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the schema was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date and time that the schema was last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time that the schema was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private String policyStoreId;

        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSchemaResponse model) {
            super(model);
            policyStoreId(model.policyStoreId);
            namespaces(model.namespaces);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespaceListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespaceListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public PutSchemaResponse build() {
            return new PutSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
