/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdConnectTokenSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenIdConnectConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenIdConnectConfiguration> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(OpenIdConnectConfiguration.getter(OpenIdConnectConfiguration::issuer)).setter(OpenIdConnectConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> ENTITY_ID_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdPrefix").getter(OpenIdConnectConfiguration.getter(OpenIdConnectConfiguration::entityIdPrefix)).setter(OpenIdConnectConfiguration.setter(Builder::entityIdPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdPrefix").build()}).build();
    private static final SdkField<OpenIdConnectGroupConfiguration> GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupConfiguration").getter(OpenIdConnectConfiguration.getter(OpenIdConnectConfiguration::groupConfiguration)).setter(OpenIdConnectConfiguration.setter(Builder::groupConfiguration)).constructor(OpenIdConnectGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupConfiguration").build()}).build();
    private static final SdkField<OpenIdConnectTokenSelection> TOKEN_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenSelection").getter(OpenIdConnectConfiguration.getter(OpenIdConnectConfiguration::tokenSelection)).setter(OpenIdConnectConfiguration.setter(Builder::tokenSelection)).constructor(OpenIdConnectTokenSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, ENTITY_ID_PREFIX_FIELD, GROUP_CONFIGURATION_FIELD, TOKEN_SELECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("issuer", ISSUER_FIELD);
            this.put("entityIdPrefix", ENTITY_ID_PREFIX_FIELD);
            this.put("groupConfiguration", GROUP_CONFIGURATION_FIELD);
            this.put("tokenSelection", TOKEN_SELECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final String entityIdPrefix;
    private final OpenIdConnectGroupConfiguration groupConfiguration;
    private final OpenIdConnectTokenSelection tokenSelection;

    private OpenIdConnectConfiguration(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.entityIdPrefix = builder.entityIdPrefix;
        this.groupConfiguration = builder.groupConfiguration;
        this.tokenSelection = builder.tokenSelection;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String entityIdPrefix() {
        return this.entityIdPrefix;
    }

    public final OpenIdConnectGroupConfiguration groupConfiguration() {
        return this.groupConfiguration;
    }

    public final OpenIdConnectTokenSelection tokenSelection() {
        return this.tokenSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConnectConfiguration)) {
            return false;
        }
        OpenIdConnectConfiguration other = (OpenIdConnectConfiguration)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.entityIdPrefix(), other.entityIdPrefix()) && Objects.equals(this.groupConfiguration(), other.groupConfiguration()) && Objects.equals(this.tokenSelection(), other.tokenSelection());
    }

    public final String toString() {
        return ToString.builder((String)"OpenIdConnectConfiguration").add("Issuer", (Object)this.issuer()).add("EntityIdPrefix", (Object)(this.entityIdPrefix() == null ? null : "*** Sensitive Data Redacted ***")).add("GroupConfiguration", (Object)this.groupConfiguration()).add("TokenSelection", (Object)this.tokenSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "entityIdPrefix": {
                return Optional.ofNullable(clazz.cast(this.entityIdPrefix()));
            }
            case "groupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupConfiguration()));
            }
            case "tokenSelection": {
                return Optional.ofNullable(clazz.cast(this.tokenSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenIdConnectConfiguration, T> g) {
        return obj -> g.apply((OpenIdConnectConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String entityIdPrefix;
        private OpenIdConnectGroupConfiguration groupConfiguration;
        private OpenIdConnectTokenSelection tokenSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIdConnectConfiguration model) {
            this.issuer(model.issuer);
            this.entityIdPrefix(model.entityIdPrefix);
            this.groupConfiguration(model.groupConfiguration);
            this.tokenSelection(model.tokenSelection);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getEntityIdPrefix() {
            return this.entityIdPrefix;
        }

        public final void setEntityIdPrefix(String entityIdPrefix) {
            this.entityIdPrefix = entityIdPrefix;
        }

        @Override
        public final Builder entityIdPrefix(String entityIdPrefix) {
            this.entityIdPrefix = entityIdPrefix;
            return this;
        }

        public final OpenIdConnectGroupConfiguration.Builder getGroupConfiguration() {
            return this.groupConfiguration != null ? this.groupConfiguration.toBuilder() : null;
        }

        public final void setGroupConfiguration(OpenIdConnectGroupConfiguration.BuilderImpl groupConfiguration) {
            this.groupConfiguration = groupConfiguration != null ? groupConfiguration.build() : null;
        }

        @Override
        public final Builder groupConfiguration(OpenIdConnectGroupConfiguration groupConfiguration) {
            this.groupConfiguration = groupConfiguration;
            return this;
        }

        public final OpenIdConnectTokenSelection.Builder getTokenSelection() {
            return this.tokenSelection != null ? this.tokenSelection.toBuilder() : null;
        }

        public final void setTokenSelection(OpenIdConnectTokenSelection.BuilderImpl tokenSelection) {
            this.tokenSelection = tokenSelection != null ? tokenSelection.build() : null;
        }

        @Override
        public final Builder tokenSelection(OpenIdConnectTokenSelection tokenSelection) {
            this.tokenSelection = tokenSelection;
            return this;
        }

        public OpenIdConnectConfiguration build() {
            return new OpenIdConnectConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenIdConnectConfiguration> {
        public Builder issuer(String var1);

        public Builder entityIdPrefix(String var1);

        public Builder groupConfiguration(OpenIdConnectGroupConfiguration var1);

        default public Builder groupConfiguration(Consumer<OpenIdConnectGroupConfiguration.Builder> groupConfiguration) {
            return this.groupConfiguration((OpenIdConnectGroupConfiguration)((OpenIdConnectGroupConfiguration.Builder)OpenIdConnectGroupConfiguration.builder().applyMutation(groupConfiguration)).build());
        }

        public Builder tokenSelection(OpenIdConnectTokenSelection var1);

        default public Builder tokenSelection(Consumer<OpenIdConnectTokenSelection.Builder> tokenSelection) {
            return this.tokenSelection((OpenIdConnectTokenSelection)((OpenIdConnectTokenSelection.Builder)OpenIdConnectTokenSelection.builder().applyMutation(tokenSelection)).build());
        }
    }
}

