/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an integer value that represents the value for number of concurrent connections or the user sessions on your
 * web app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebAppUnits implements SdkPojo, Serializable, ToCopyableBuilder<WebAppUnits.Builder, WebAppUnits> {
    private static final SdkField<Integer> PROVISIONED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Provisioned").getter(getter(WebAppUnits::provisioned)).setter(setter(Builder::provisioned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provisioned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer provisioned;

    private final Type type;

    private WebAppUnits(BuilderImpl builder) {
        this.provisioned = builder.provisioned;
        this.type = builder.type;
    }

    /**
     * <p>
     * An integer that represents the number of units for your desired number of concurrent connections, or the number
     * of user sessions on your web app at the same time.
     * </p>
     * <p>
     * Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of
     * concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
     * </p>
     * 
     * @return An integer that represents the number of units for your desired number of concurrent connections, or the
     *         number of user sessions on your web app at the same time.</p>
     *         <p>
     *         Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of
     *         concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
     */
    public final Integer provisioned() {
        return provisioned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAppUnits)) {
            return false;
        }
        WebAppUnits other = (WebAppUnits) obj;
        return Objects.equals(provisioned(), other.provisioned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebAppUnits").add("Provisioned", provisioned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #provisioned()} initialized to the given value.
     *
     * <p>
     * An integer that represents the number of units for your desired number of concurrent connections, or the number
     * of user sessions on your web app at the same time.
     * </p>
     * <p>
     * Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of
     * concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
     * </p>
     * 
     * @param provisioned
     *        An integer that represents the number of units for your desired number of concurrent connections, or the
     *        number of user sessions on your web app at the same time.</p>
     *        <p>
     *        Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of
     *        concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
     */
    public static WebAppUnits fromProvisioned(Integer provisioned) {
        return builder().provisioned(provisioned).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Provisioned", PROVISIONED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAppUnits, T> g) {
        return obj -> g.apply((WebAppUnits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebAppUnits> {
        /**
         * <p>
         * An integer that represents the number of units for your desired number of concurrent connections, or the
         * number of user sessions on your web app at the same time.
         * </p>
         * <p>
         * Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number of
         * concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
         * </p>
         * 
         * @param provisioned
         *        An integer that represents the number of units for your desired number of concurrent connections, or
         *        the number of user sessions on your web app at the same time.</p>
         *        <p>
         *        Each increment allows an additional 250 concurrent sessions: a value of <code>1</code> sets the number
         *        of concurrent sessions to 250; <code>2</code> sets a value of 500, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(Integer provisioned);
    }

    static final class BuilderImpl implements Builder {
        private Integer provisioned;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WebAppUnits model) {
            provisioned(model.provisioned);
        }

        public final Integer getProvisioned() {
            return provisioned;
        }

        public final void setProvisioned(Integer provisioned) {
            Object oldValue = this.provisioned;
            this.provisioned = provisioned;
            handleUnionValueChange(Type.PROVISIONED, oldValue, this.provisioned);
        }

        @Override
        public final Builder provisioned(Integer provisioned) {
            Object oldValue = this.provisioned;
            this.provisioned = provisioned;
            handleUnionValueChange(Type.PROVISIONED, oldValue, this.provisioned);
            return this;
        }

        @Override
        public WebAppUnits build() {
            return new WebAppUnits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WebAppUnits#type()
     */
    public enum Type {
        PROVISIONED,

        UNKNOWN_TO_SDK_VERSION
    }
}
