/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union that contains the <code>IdentityCenterConfig</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebAppIdentityProviderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<WebAppIdentityProviderDetails.Builder, WebAppIdentityProviderDetails> {
    private static final SdkField<IdentityCenterConfig> IDENTITY_CENTER_CONFIG_FIELD = SdkField
            .<IdentityCenterConfig> builder(MarshallingType.SDK_POJO).memberName("IdentityCenterConfig")
            .getter(getter(WebAppIdentityProviderDetails::identityCenterConfig)).setter(setter(Builder::identityCenterConfig))
            .constructor(IdentityCenterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_CENTER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IdentityCenterConfig identityCenterConfig;

    private final Type type;

    private WebAppIdentityProviderDetails(BuilderImpl builder) {
        this.identityCenterConfig = builder.identityCenterConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you create a web app.
     * </p>
     * 
     * @return A structure that describes the values to use for the IAM Identity Center settings when you create a web
     *         app.
     */
    public final IdentityCenterConfig identityCenterConfig() {
        return identityCenterConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAppIdentityProviderDetails)) {
            return false;
        }
        WebAppIdentityProviderDetails other = (WebAppIdentityProviderDetails) obj;
        return Objects.equals(identityCenterConfig(), other.identityCenterConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebAppIdentityProviderDetails").add("IdentityCenterConfig", identityCenterConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityCenterConfig":
            return Optional.ofNullable(clazz.cast(identityCenterConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #identityCenterConfig()} initialized to the given value.
     *
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you create a web app.
     * </p>
     * 
     * @param identityCenterConfig
     *        A structure that describes the values to use for the IAM Identity Center settings when you create a web
     *        app.
     */
    public static WebAppIdentityProviderDetails fromIdentityCenterConfig(IdentityCenterConfig identityCenterConfig) {
        return builder().identityCenterConfig(identityCenterConfig).build();
    }

    /**
     * Create an instance of this class with {@link #identityCenterConfig()} initialized to the given value.
     *
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you create a web app.
     * </p>
     * 
     * @param identityCenterConfig
     *        A structure that describes the values to use for the IAM Identity Center settings when you create a web
     *        app.
     */
    public static WebAppIdentityProviderDetails fromIdentityCenterConfig(
            Consumer<IdentityCenterConfig.Builder> identityCenterConfig) {
        IdentityCenterConfig.Builder builder = IdentityCenterConfig.builder();
        identityCenterConfig.accept(builder);
        return fromIdentityCenterConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityCenterConfig", IDENTITY_CENTER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAppIdentityProviderDetails, T> g) {
        return obj -> g.apply((WebAppIdentityProviderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebAppIdentityProviderDetails> {
        /**
         * <p>
         * A structure that describes the values to use for the IAM Identity Center settings when you create a web app.
         * </p>
         * 
         * @param identityCenterConfig
         *        A structure that describes the values to use for the IAM Identity Center settings when you create a
         *        web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterConfig(IdentityCenterConfig identityCenterConfig);

        /**
         * <p>
         * A structure that describes the values to use for the IAM Identity Center settings when you create a web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityCenterConfig.Builder} avoiding
         * the need to create one manually via {@link IdentityCenterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityCenterConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #identityCenterConfig(IdentityCenterConfig)}.
         * 
         * @param identityCenterConfig
         *        a consumer that will call methods on {@link IdentityCenterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityCenterConfig(IdentityCenterConfig)
         */
        default Builder identityCenterConfig(Consumer<IdentityCenterConfig.Builder> identityCenterConfig) {
            return identityCenterConfig(IdentityCenterConfig.builder().applyMutation(identityCenterConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IdentityCenterConfig identityCenterConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WebAppIdentityProviderDetails model) {
            identityCenterConfig(model.identityCenterConfig);
        }

        public final IdentityCenterConfig.Builder getIdentityCenterConfig() {
            return identityCenterConfig != null ? identityCenterConfig.toBuilder() : null;
        }

        public final void setIdentityCenterConfig(IdentityCenterConfig.BuilderImpl identityCenterConfig) {
            Object oldValue = this.identityCenterConfig;
            this.identityCenterConfig = identityCenterConfig != null ? identityCenterConfig.build() : null;
            handleUnionValueChange(Type.IDENTITY_CENTER_CONFIG, oldValue, this.identityCenterConfig);
        }

        @Override
        public final Builder identityCenterConfig(IdentityCenterConfig identityCenterConfig) {
            Object oldValue = this.identityCenterConfig;
            this.identityCenterConfig = identityCenterConfig;
            handleUnionValueChange(Type.IDENTITY_CENTER_CONFIG, oldValue, this.identityCenterConfig);
            return this;
        }

        @Override
        public WebAppIdentityProviderDetails build() {
            return new WebAppIdentityProviderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WebAppIdentityProviderDetails#type()
     */
    public enum Type {
        IDENTITY_CENTER_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
