/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union that contains the <code>UpdateWebAppIdentityCenterConfig</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAppIdentityProviderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateWebAppIdentityProviderDetails.Builder, UpdateWebAppIdentityProviderDetails> {
    private static final SdkField<UpdateWebAppIdentityCenterConfig> IDENTITY_CENTER_CONFIG_FIELD = SdkField
            .<UpdateWebAppIdentityCenterConfig> builder(MarshallingType.SDK_POJO).memberName("IdentityCenterConfig")
            .getter(getter(UpdateWebAppIdentityProviderDetails::identityCenterConfig))
            .setter(setter(Builder::identityCenterConfig)).constructor(UpdateWebAppIdentityCenterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_CENTER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateWebAppIdentityCenterConfig identityCenterConfig;

    private final Type type;

    private UpdateWebAppIdentityProviderDetails(BuilderImpl builder) {
        this.identityCenterConfig = builder.identityCenterConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you update a web app.
     * </p>
     * 
     * @return A structure that describes the values to use for the IAM Identity Center settings when you update a web
     *         app.
     */
    public final UpdateWebAppIdentityCenterConfig identityCenterConfig() {
        return identityCenterConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAppIdentityProviderDetails)) {
            return false;
        }
        UpdateWebAppIdentityProviderDetails other = (UpdateWebAppIdentityProviderDetails) obj;
        return Objects.equals(identityCenterConfig(), other.identityCenterConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebAppIdentityProviderDetails").add("IdentityCenterConfig", identityCenterConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityCenterConfig":
            return Optional.ofNullable(clazz.cast(identityCenterConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #identityCenterConfig()} initialized to the given value.
     *
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you update a web app.
     * </p>
     * 
     * @param identityCenterConfig
     *        A structure that describes the values to use for the IAM Identity Center settings when you update a web
     *        app.
     */
    public static UpdateWebAppIdentityProviderDetails fromIdentityCenterConfig(
            UpdateWebAppIdentityCenterConfig identityCenterConfig) {
        return builder().identityCenterConfig(identityCenterConfig).build();
    }

    /**
     * Create an instance of this class with {@link #identityCenterConfig()} initialized to the given value.
     *
     * <p>
     * A structure that describes the values to use for the IAM Identity Center settings when you update a web app.
     * </p>
     * 
     * @param identityCenterConfig
     *        A structure that describes the values to use for the IAM Identity Center settings when you update a web
     *        app.
     */
    public static UpdateWebAppIdentityProviderDetails fromIdentityCenterConfig(
            Consumer<UpdateWebAppIdentityCenterConfig.Builder> identityCenterConfig) {
        UpdateWebAppIdentityCenterConfig.Builder builder = UpdateWebAppIdentityCenterConfig.builder();
        identityCenterConfig.accept(builder);
        return fromIdentityCenterConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityCenterConfig", IDENTITY_CENTER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAppIdentityProviderDetails, T> g) {
        return obj -> g.apply((UpdateWebAppIdentityProviderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateWebAppIdentityProviderDetails> {
        /**
         * <p>
         * A structure that describes the values to use for the IAM Identity Center settings when you update a web app.
         * </p>
         * 
         * @param identityCenterConfig
         *        A structure that describes the values to use for the IAM Identity Center settings when you update a
         *        web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterConfig(UpdateWebAppIdentityCenterConfig identityCenterConfig);

        /**
         * <p>
         * A structure that describes the values to use for the IAM Identity Center settings when you update a web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateWebAppIdentityCenterConfig.Builder}
         * avoiding the need to create one manually via {@link UpdateWebAppIdentityCenterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateWebAppIdentityCenterConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #identityCenterConfig(UpdateWebAppIdentityCenterConfig)}.
         * 
         * @param identityCenterConfig
         *        a consumer that will call methods on {@link UpdateWebAppIdentityCenterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityCenterConfig(UpdateWebAppIdentityCenterConfig)
         */
        default Builder identityCenterConfig(Consumer<UpdateWebAppIdentityCenterConfig.Builder> identityCenterConfig) {
            return identityCenterConfig(UpdateWebAppIdentityCenterConfig.builder().applyMutation(identityCenterConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateWebAppIdentityCenterConfig identityCenterConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAppIdentityProviderDetails model) {
            identityCenterConfig(model.identityCenterConfig);
        }

        public final UpdateWebAppIdentityCenterConfig.Builder getIdentityCenterConfig() {
            return identityCenterConfig != null ? identityCenterConfig.toBuilder() : null;
        }

        public final void setIdentityCenterConfig(UpdateWebAppIdentityCenterConfig.BuilderImpl identityCenterConfig) {
            Object oldValue = this.identityCenterConfig;
            this.identityCenterConfig = identityCenterConfig != null ? identityCenterConfig.build() : null;
            handleUnionValueChange(Type.IDENTITY_CENTER_CONFIG, oldValue, this.identityCenterConfig);
        }

        @Override
        public final Builder identityCenterConfig(UpdateWebAppIdentityCenterConfig identityCenterConfig) {
            Object oldValue = this.identityCenterConfig;
            this.identityCenterConfig = identityCenterConfig;
            handleUnionValueChange(Type.IDENTITY_CENTER_CONFIG, oldValue, this.identityCenterConfig);
            return this;
        }

        @Override
        public UpdateWebAppIdentityProviderDetails build() {
            return new UpdateWebAppIdentityProviderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateWebAppIdentityProviderDetails#type()
     */
    public enum Type {
        IDENTITY_CENTER_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
