/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAppCustomizationRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateWebAppCustomizationRequest.Builder, UpdateWebAppCustomizationRequest> {
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppId").getter(getter(UpdateWebAppCustomizationRequest::webAppId)).setter(setter(Builder::webAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(UpdateWebAppCustomizationRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<SdkBytes> LOGO_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("LogoFile").getter(getter(UpdateWebAppCustomizationRequest::logoFile)).setter(setter(Builder::logoFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoFile").build()).build();

    private static final SdkField<SdkBytes> FAVICON_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("FaviconFile").getter(getter(UpdateWebAppCustomizationRequest::faviconFile))
            .setter(setter(Builder::faviconFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_ID_FIELD, TITLE_FIELD,
            LOGO_FILE_FIELD, FAVICON_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webAppId;

    private final String title;

    private final SdkBytes logoFile;

    private final SdkBytes faviconFile;

    private UpdateWebAppCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.webAppId = builder.webAppId;
        this.title = builder.title;
        this.logoFile = builder.logoFile;
        this.faviconFile = builder.faviconFile;
    }

    /**
     * <p>
     * Provide the identifier of the web app that you are updating.
     * </p>
     * 
     * @return Provide the identifier of the web app that you are updating.
     */
    public final String webAppId() {
        return webAppId;
    }

    /**
     * <p>
     * Provide an updated title.
     * </p>
     * 
     * @return Provide an updated title.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Specify logo file data string (in base64 encoding).
     * </p>
     * 
     * @return Specify logo file data string (in base64 encoding).
     */
    public final SdkBytes logoFile() {
        return logoFile;
    }

    /**
     * <p>
     * Specify icon file data string (in base64 encoding).
     * </p>
     * 
     * @return Specify icon file data string (in base64 encoding).
     */
    public final SdkBytes faviconFile() {
        return faviconFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(logoFile());
        hashCode = 31 * hashCode + Objects.hashCode(faviconFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAppCustomizationRequest)) {
            return false;
        }
        UpdateWebAppCustomizationRequest other = (UpdateWebAppCustomizationRequest) obj;
        return Objects.equals(webAppId(), other.webAppId()) && Objects.equals(title(), other.title())
                && Objects.equals(logoFile(), other.logoFile()) && Objects.equals(faviconFile(), other.faviconFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebAppCustomizationRequest").add("WebAppId", webAppId()).add("Title", title())
                .add("LogoFile", logoFile() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FaviconFile", faviconFile() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAppId":
            return Optional.ofNullable(clazz.cast(webAppId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "LogoFile":
            return Optional.ofNullable(clazz.cast(logoFile()));
        case "FaviconFile":
            return Optional.ofNullable(clazz.cast(faviconFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("LogoFile", LOGO_FILE_FIELD);
        map.put("FaviconFile", FAVICON_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAppCustomizationRequest, T> g) {
        return obj -> g.apply((UpdateWebAppCustomizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebAppCustomizationRequest> {
        /**
         * <p>
         * Provide the identifier of the web app that you are updating.
         * </p>
         * 
         * @param webAppId
         *        Provide the identifier of the web app that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppId(String webAppId);

        /**
         * <p>
         * Provide an updated title.
         * </p>
         * 
         * @param title
         *        Provide an updated title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Specify logo file data string (in base64 encoding).
         * </p>
         * 
         * @param logoFile
         *        Specify logo file data string (in base64 encoding).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoFile(SdkBytes logoFile);

        /**
         * <p>
         * Specify icon file data string (in base64 encoding).
         * </p>
         * 
         * @param faviconFile
         *        Specify icon file data string (in base64 encoding).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faviconFile(SdkBytes faviconFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String webAppId;

        private String title;

        private SdkBytes logoFile;

        private SdkBytes faviconFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAppCustomizationRequest model) {
            super(model);
            webAppId(model.webAppId);
            title(model.title);
            logoFile(model.logoFile);
            faviconFile(model.faviconFile);
        }

        public final String getWebAppId() {
            return webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ByteBuffer getLogoFile() {
            return logoFile == null ? null : logoFile.asByteBuffer();
        }

        public final void setLogoFile(ByteBuffer logoFile) {
            logoFile(logoFile == null ? null : SdkBytes.fromByteBuffer(logoFile));
        }

        @Override
        public final Builder logoFile(SdkBytes logoFile) {
            this.logoFile = logoFile;
            return this;
        }

        public final ByteBuffer getFaviconFile() {
            return faviconFile == null ? null : faviconFile.asByteBuffer();
        }

        public final void setFaviconFile(ByteBuffer faviconFile) {
            faviconFile(faviconFile == null ? null : SdkBytes.fromByteBuffer(faviconFile));
        }

        @Override
        public final Builder faviconFile(SdkBytes faviconFile) {
            this.faviconFile = faviconFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAppCustomizationRequest build() {
            return new UpdateWebAppCustomizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
