/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowsResponse extends TransferResponse implements
        ToCopyableBuilder<ListWorkflowsResponse.Builder, ListWorkflowsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkflowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedWorkflow>> WORKFLOWS_FIELD = SdkField
            .<List<ListedWorkflow>> builder(MarshallingType.LIST)
            .memberName("Workflows")
            .getter(getter(ListWorkflowsResponse::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedWorkflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedWorkflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKFLOWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListedWorkflow> workflows;

    private ListWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workflows = builder.workflows;
    }

    /**
     * <p>
     * <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
     * <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.
     * </p>
     * 
     * @return <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass
     *         the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
     */
    public final List<ListedWorkflow> workflows() {
        return workflows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsResponse)) {
            return false;
        }
        ListWorkflowsResponse other = (ListWorkflowsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkflows() == other.hasWorkflows()
                && Objects.equals(workflows(), other.workflows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowsResponse").add("NextToken", nextToken())
                .add("Workflows", hasWorkflows() ? workflows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Workflows", WORKFLOWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsResponse, T> g) {
        return obj -> g.apply((ListWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkflowsResponse> {
        /**
         * <p>
         * <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
         * <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.
         * </p>
         * 
         * @param nextToken
         *        <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then
         *        pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional
         *        workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
         * </p>
         * 
         * @param workflows
         *        Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<ListedWorkflow> workflows);

        /**
         * <p>
         * Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
         * </p>
         * 
         * @param workflows
         *        Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(ListedWorkflow... workflows);

        /**
         * <p>
         * Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedWorkflow.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.ListedWorkflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedWorkflow.Builder#build()} is called immediately
         * and its result is passed to {@link #workflows(List<ListedWorkflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedWorkflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<ListedWorkflow>)
         */
        Builder workflows(Consumer<ListedWorkflow.Builder>... workflows);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedWorkflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workflows(model.workflows);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedWorkflow.Builder> getWorkflows() {
            List<ListedWorkflow.Builder> result = ListedWorkflowsCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<ListedWorkflow.BuilderImpl> workflows) {
            this.workflows = ListedWorkflowsCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<ListedWorkflow> workflows) {
            this.workflows = ListedWorkflowsCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(ListedWorkflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<ListedWorkflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> ListedWorkflow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkflowsResponse build() {
            return new ListWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
