/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersResponse extends TransferResponse implements
        ToCopyableBuilder<ListUsersResponse.Builder, ListUsersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ListUsersResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<List<ListedUser>> USERS_FIELD = SdkField
            .<List<ListedUser>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(ListUsersResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVER_ID_FIELD, USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String serverId;

    private final List<ListedUser> users;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverId = builder.serverId;
        this.users = builder.users;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is
     * returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional users.
     * </p>
     * 
     * @return When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code>
     *         parameter is returned in the output. You can then pass in a subsequent command to the
     *         <code>NextToken</code> parameter to continue listing additional users.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that the users are assigned to.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server that the users are assigned to.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you
     *         specify.
     */
    public final List<ListedUser> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(serverId(), other.serverId())
                && hasUsers() == other.hasUsers() && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUsersResponse").add("NextToken", nextToken()).add("ServerId", serverId())
                .add("Users", hasUsers() ? users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("Users", USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUsersResponse> {
        /**
         * <p>
         * When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter
         * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter
         * to continue listing additional users.
         * </p>
         * 
         * @param nextToken
         *        When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code>
         *        parameter is returned in the output. You can then pass in a subsequent command to the
         *        <code>NextToken</code> parameter to continue listing additional users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A system-assigned unique identifier for a server that the users are assigned to.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server that the users are assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * 
         * @param users
         *        Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you
         *        specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<ListedUser> users);

        /**
         * <p>
         * Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * 
         * @param users
         *        Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you
         *        specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(ListedUser... users);

        /**
         * <p>
         * Returns the Transfer Family users and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedUser.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.ListedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedUser.Builder#build()} is called immediately and
         * its result is passed to {@link #users(List<ListedUser>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<ListedUser>)
         */
        Builder users(Consumer<ListedUser.Builder>... users);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String serverId;

        private List<ListedUser> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            nextToken(model.nextToken);
            serverId(model.serverId);
            users(model.users);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final List<ListedUser.Builder> getUsers() {
            List<ListedUser.Builder> result = ListedUsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<ListedUser.BuilderImpl> users) {
            this.users = ListedUsersCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<ListedUser> users) {
            this.users = ListedUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(ListedUser... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<ListedUser.Builder>... users) {
            users(Stream.of(users).map(c -> ListedUser.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
