/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileTransferResultsResponse extends TransferResponse implements
        ToCopyableBuilder<ListFileTransferResultsResponse.Builder, ListFileTransferResultsResponse> {
    private static final SdkField<List<ConnectorFileTransferResult>> FILE_TRANSFER_RESULTS_FIELD = SdkField
            .<List<ConnectorFileTransferResult>> builder(MarshallingType.LIST)
            .memberName("FileTransferResults")
            .getter(getter(ListFileTransferResultsResponse::fileTransferResults))
            .setter(setter(Builder::fileTransferResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileTransferResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorFileTransferResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorFileTransferResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFileTransferResultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TRANSFER_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConnectorFileTransferResult> fileTransferResults;

    private final String nextToken;

    private ListFileTransferResultsResponse(BuilderImpl builder) {
        super(builder);
        this.fileTransferResults = builder.fileTransferResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileTransferResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileTransferResults() {
        return fileTransferResults != null && !(fileTransferResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the details for the files transferred in the transfer identified by the <code>TransferId</code> and
     * <code>ConnectorId</code> specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StatusCode</code>: current status for the transfer. The status returned is one of the following values:
     * <code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the reason. For
     * example, <code>RETRIEVE_FILE_NOT_FOUND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileTransferResults} method.
     * </p>
     * 
     * @return Returns the details for the files transferred in the transfer identified by the <code>TransferId</code>
     *         and <code>ConnectorId</code> specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StatusCode</code>: current status for the transfer. The status returned is one of the following
     *         values:<code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the reason.
     *         For example, <code>RETRIEVE_FILE_NOT_FOUND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the
     *         failure.
     *         </p>
     *         </li>
     */
    public final List<ConnectorFileTransferResult> fileTransferResults() {
        return fileTransferResults;
    }

    /**
     * <p>
     * Returns a token that you can use to call <code>ListFileTransferResults</code> again and receive additional
     * results, if there are any (against the same <code>TransferId</code>.
     * </p>
     * 
     * @return Returns a token that you can use to call <code>ListFileTransferResults</code> again and receive
     *         additional results, if there are any (against the same <code>TransferId</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFileTransferResults() ? fileTransferResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileTransferResultsResponse)) {
            return false;
        }
        ListFileTransferResultsResponse other = (ListFileTransferResultsResponse) obj;
        return hasFileTransferResults() == other.hasFileTransferResults()
                && Objects.equals(fileTransferResults(), other.fileTransferResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFileTransferResultsResponse")
                .add("FileTransferResults", hasFileTransferResults() ? fileTransferResults() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileTransferResults":
            return Optional.ofNullable(clazz.cast(fileTransferResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileTransferResults", FILE_TRANSFER_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFileTransferResultsResponse, T> g) {
        return obj -> g.apply((ListFileTransferResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFileTransferResultsResponse> {
        /**
         * <p>
         * Returns the details for the files transferred in the transfer identified by the <code>TransferId</code> and
         * <code>ConnectorId</code> specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusCode</code>: current status for the transfer. The status returned is one of the following values:
         * <code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the reason. For
         * example, <code>RETRIEVE_FILE_NOT_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileTransferResults
         *        Returns the details for the files transferred in the transfer identified by the
         *        <code>TransferId</code> and <code>ConnectorId</code> specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StatusCode</code>: current status for the transfer. The status returned is one of the following
         *        values:<code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the
         *        reason. For example, <code>RETRIEVE_FILE_NOT_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the
         *        failure.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileTransferResults(Collection<ConnectorFileTransferResult> fileTransferResults);

        /**
         * <p>
         * Returns the details for the files transferred in the transfer identified by the <code>TransferId</code> and
         * <code>ConnectorId</code> specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusCode</code>: current status for the transfer. The status returned is one of the following values:
         * <code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the reason. For
         * example, <code>RETRIEVE_FILE_NOT_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileTransferResults
         *        Returns the details for the files transferred in the transfer identified by the
         *        <code>TransferId</code> and <code>ConnectorId</code> specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StatusCode</code>: current status for the transfer. The status returned is one of the following
         *        values:<code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the
         *        reason. For example, <code>RETRIEVE_FILE_NOT_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the
         *        failure.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileTransferResults(ConnectorFileTransferResult... fileTransferResults);

        /**
         * <p>
         * Returns the details for the files transferred in the transfer identified by the <code>TransferId</code> and
         * <code>ConnectorId</code> specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FilePath</code>: the filename and path to where the file was sent to or retrieved from.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusCode</code>: current status for the transfer. The status returned is one of the following values:
         * <code>QUEUED</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, or <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureCode</code>: for transfers that fail, this parameter contains a code indicating the reason. For
         * example, <code>RETRIEVE_FILE_NOT_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureMessage</code>: for transfers that fail, this parameter describes the reason for the failure.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult.Builder#build()} is called
         * immediately and its result is passed to {@link #fileTransferResults(List<ConnectorFileTransferResult>)}.
         * 
         * @param fileTransferResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileTransferResults(java.util.Collection<ConnectorFileTransferResult>)
         */
        Builder fileTransferResults(Consumer<ConnectorFileTransferResult.Builder>... fileTransferResults);

        /**
         * <p>
         * Returns a token that you can use to call <code>ListFileTransferResults</code> again and receive additional
         * results, if there are any (against the same <code>TransferId</code>.
         * </p>
         * 
         * @param nextToken
         *        Returns a token that you can use to call <code>ListFileTransferResults</code> again and receive
         *        additional results, if there are any (against the same <code>TransferId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private List<ConnectorFileTransferResult> fileTransferResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileTransferResultsResponse model) {
            super(model);
            fileTransferResults(model.fileTransferResults);
            nextToken(model.nextToken);
        }

        public final List<ConnectorFileTransferResult.Builder> getFileTransferResults() {
            List<ConnectorFileTransferResult.Builder> result = ConnectorFileTransferResultsCopier
                    .copyToBuilder(this.fileTransferResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileTransferResults(Collection<ConnectorFileTransferResult.BuilderImpl> fileTransferResults) {
            this.fileTransferResults = ConnectorFileTransferResultsCopier.copyFromBuilder(fileTransferResults);
        }

        @Override
        public final Builder fileTransferResults(Collection<ConnectorFileTransferResult> fileTransferResults) {
            this.fileTransferResults = ConnectorFileTransferResultsCopier.copy(fileTransferResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileTransferResults(ConnectorFileTransferResult... fileTransferResults) {
            fileTransferResults(Arrays.asList(fileTransferResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileTransferResults(Consumer<ConnectorFileTransferResult.Builder>... fileTransferResults) {
            fileTransferResults(Stream.of(fileTransferResults)
                    .map(c -> ConnectorFileTransferResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFileTransferResultsResponse build() {
            return new ListFileTransferResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
