/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to
 * customize the appearance of your web app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedWebAppCustomization implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedWebAppCustomization.Builder, DescribedWebAppCustomization> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedWebAppCustomization::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppId").getter(getter(DescribedWebAppCustomization::webAppId)).setter(setter(Builder::webAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(DescribedWebAppCustomization::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<SdkBytes> LOGO_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("LogoFile").getter(getter(DescribedWebAppCustomization::logoFile)).setter(setter(Builder::logoFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoFile").build()).build();

    private static final SdkField<SdkBytes> FAVICON_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("FaviconFile").getter(getter(DescribedWebAppCustomization::faviconFile))
            .setter(setter(Builder::faviconFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD,
            TITLE_FIELD, LOGO_FILE_FIELD, FAVICON_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String webAppId;

    private final String title;

    private final SdkBytes logoFile;

    private final SdkBytes faviconFile;

    private DescribedWebAppCustomization(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.title = builder.title;
        this.logoFile = builder.logoFile;
        this.faviconFile = builder.faviconFile;
    }

    /**
     * <p>
     * Returns the Amazon Resource Name (ARN) for the web app.
     * </p>
     * 
     * @return Returns the Amazon Resource Name (ARN) for the web app.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Returns the unique identifier for your web app.
     * </p>
     * 
     * @return Returns the unique identifier for your web app.
     */
    public final String webAppId() {
        return webAppId;
    }

    /**
     * <p>
     * Returns the page title that you defined for your web app.
     * </p>
     * 
     * @return Returns the page title that you defined for your web app.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Returns a logo file data string (in base64 encoding).
     * </p>
     * 
     * @return Returns a logo file data string (in base64 encoding).
     */
    public final SdkBytes logoFile() {
        return logoFile;
    }

    /**
     * <p>
     * Returns a icon file data string (in base64 encoding).
     * </p>
     * 
     * @return Returns a icon file data string (in base64 encoding).
     */
    public final SdkBytes faviconFile() {
        return faviconFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(logoFile());
        hashCode = 31 * hashCode + Objects.hashCode(faviconFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebAppCustomization)) {
            return false;
        }
        DescribedWebAppCustomization other = (DescribedWebAppCustomization) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(webAppId(), other.webAppId())
                && Objects.equals(title(), other.title()) && Objects.equals(logoFile(), other.logoFile())
                && Objects.equals(faviconFile(), other.faviconFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedWebAppCustomization").add("Arn", arn()).add("WebAppId", webAppId())
                .add("Title", title()).add("LogoFile", logoFile() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FaviconFile", faviconFile() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "WebAppId":
            return Optional.ofNullable(clazz.cast(webAppId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "LogoFile":
            return Optional.ofNullable(clazz.cast(logoFile()));
        case "FaviconFile":
            return Optional.ofNullable(clazz.cast(faviconFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("LogoFile", LOGO_FILE_FIELD);
        map.put("FaviconFile", FAVICON_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebAppCustomization, T> g) {
        return obj -> g.apply((DescribedWebAppCustomization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedWebAppCustomization> {
        /**
         * <p>
         * Returns the Amazon Resource Name (ARN) for the web app.
         * </p>
         * 
         * @param arn
         *        Returns the Amazon Resource Name (ARN) for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Returns the unique identifier for your web app.
         * </p>
         * 
         * @param webAppId
         *        Returns the unique identifier for your web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppId(String webAppId);

        /**
         * <p>
         * Returns the page title that you defined for your web app.
         * </p>
         * 
         * @param title
         *        Returns the page title that you defined for your web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Returns a logo file data string (in base64 encoding).
         * </p>
         * 
         * @param logoFile
         *        Returns a logo file data string (in base64 encoding).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoFile(SdkBytes logoFile);

        /**
         * <p>
         * Returns a icon file data string (in base64 encoding).
         * </p>
         * 
         * @param faviconFile
         *        Returns a icon file data string (in base64 encoding).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faviconFile(SdkBytes faviconFile);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String webAppId;

        private String title;

        private SdkBytes logoFile;

        private SdkBytes faviconFile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebAppCustomization model) {
            arn(model.arn);
            webAppId(model.webAppId);
            title(model.title);
            logoFile(model.logoFile);
            faviconFile(model.faviconFile);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ByteBuffer getLogoFile() {
            return logoFile == null ? null : logoFile.asByteBuffer();
        }

        public final void setLogoFile(ByteBuffer logoFile) {
            logoFile(logoFile == null ? null : SdkBytes.fromByteBuffer(logoFile));
        }

        @Override
        public final Builder logoFile(SdkBytes logoFile) {
            this.logoFile = logoFile;
            return this;
        }

        public final ByteBuffer getFaviconFile() {
            return faviconFile == null ? null : faviconFile.asByteBuffer();
        }

        public final void setFaviconFile(ByteBuffer faviconFile) {
            faviconFile(faviconFile == null ? null : SdkBytes.fromByteBuffer(faviconFile));
        }

        @Override
        public final Builder faviconFile(SdkBytes faviconFile) {
            this.faviconFile = faviconFile;
            return this;
        }

        @Override
        public DescribedWebAppCustomization build() {
            return new DescribedWebAppCustomization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
