/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHostKeyResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeHostKeyResponse.Builder, DescribeHostKeyResponse> {
    private static final SdkField<DescribedHostKey> HOST_KEY_FIELD = SdkField
            .<DescribedHostKey> builder(MarshallingType.SDK_POJO).memberName("HostKey")
            .getter(getter(DescribeHostKeyResponse::hostKey)).setter(setter(Builder::hostKey))
            .constructor(DescribedHostKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribedHostKey hostKey;

    private DescribeHostKeyResponse(BuilderImpl builder) {
        super(builder);
        this.hostKey = builder.hostKey;
    }

    /**
     * <p>
     * Returns the details for the specified host key.
     * </p>
     * 
     * @return Returns the details for the specified host key.
     */
    public final DescribedHostKey hostKey() {
        return hostKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostKeyResponse)) {
            return false;
        }
        DescribeHostKeyResponse other = (DescribeHostKeyResponse) obj;
        return Objects.equals(hostKey(), other.hostKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHostKeyResponse").add("HostKey", hostKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostKey":
            return Optional.ofNullable(clazz.cast(hostKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HostKey", HOST_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostKeyResponse, T> g) {
        return obj -> g.apply((DescribeHostKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHostKeyResponse> {
        /**
         * <p>
         * Returns the details for the specified host key.
         * </p>
         * 
         * @param hostKey
         *        Returns the details for the specified host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKey(DescribedHostKey hostKey);

        /**
         * <p>
         * Returns the details for the specified host key.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedHostKey.Builder} avoiding the
         * need to create one manually via {@link DescribedHostKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedHostKey.Builder#build()} is called immediately and its
         * result is passed to {@link #hostKey(DescribedHostKey)}.
         * 
         * @param hostKey
         *        a consumer that will call methods on {@link DescribedHostKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostKey(DescribedHostKey)
         */
        default Builder hostKey(Consumer<DescribedHostKey.Builder> hostKey) {
            return hostKey(DescribedHostKey.builder().applyMutation(hostKey).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedHostKey hostKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostKeyResponse model) {
            super(model);
            hostKey(model.hostKey);
        }

        public final DescribedHostKey.Builder getHostKey() {
            return hostKey != null ? hostKey.toBuilder() : null;
        }

        public final void setHostKey(DescribedHostKey.BuilderImpl hostKey) {
            this.hostKey = hostKey != null ? hostKey.build() : null;
        }

        @Override
        public final Builder hostKey(DescribedHostKey hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        @Override
        public DescribeHostKeyResponse build() {
            return new DescribeHostKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
