/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TranscriptFilterType {
    EXACT("EXACT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TranscriptFilterType> VALUE_MAP;
    private final String value;

    private TranscriptFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TranscriptFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TranscriptFilterType> knownValues() {
        EnumSet<TranscriptFilterType> knownValues = EnumSet.allOf(TranscriptFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TranscriptFilterType.class, TranscriptFilterType::toString);
    }
}

