/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CallAnalyticsSkippedReasonCode {
    INSUFFICIENT_CONVERSATION_CONTENT("INSUFFICIENT_CONVERSATION_CONTENT"),
    FAILED_SAFETY_GUIDELINES("FAILED_SAFETY_GUIDELINES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CallAnalyticsSkippedReasonCode> VALUE_MAP;
    private final String value;

    private CallAnalyticsSkippedReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CallAnalyticsSkippedReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CallAnalyticsSkippedReasonCode> knownValues() {
        EnumSet<CallAnalyticsSkippedReasonCode> knownValues = EnumSet.allOf(CallAnalyticsSkippedReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CallAnalyticsSkippedReasonCode.class, CallAnalyticsSkippedReasonCode::toString);
    }
}

