/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;

public class ListVocabularyFiltersIterable
implements SdkIterable<ListVocabularyFiltersResponse> {
    private final TranscribeClient client;
    private final ListVocabularyFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVocabularyFiltersIterable(TranscribeClient client, ListVocabularyFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVocabularyFiltersResponseFetcher();
    }

    public Iterator<ListVocabularyFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVocabularyFiltersResponseFetcher
    implements SyncPageFetcher<ListVocabularyFiltersResponse> {
        private ListVocabularyFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListVocabularyFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVocabularyFiltersResponse nextPage(ListVocabularyFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListVocabularyFiltersIterable.this.client.listVocabularyFilters(ListVocabularyFiltersIterable.this.firstRequest);
            }
            return ListVocabularyFiltersIterable.this.client.listVocabularyFilters((ListVocabularyFiltersRequest)((Object)ListVocabularyFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

