/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse;

public class ListLanguageModelsIterable
implements SdkIterable<ListLanguageModelsResponse> {
    private final TranscribeClient client;
    private final ListLanguageModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLanguageModelsIterable(TranscribeClient client, ListLanguageModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLanguageModelsResponseFetcher();
    }

    public Iterator<ListLanguageModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLanguageModelsResponseFetcher
    implements SyncPageFetcher<ListLanguageModelsResponse> {
        private ListLanguageModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListLanguageModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLanguageModelsResponse nextPage(ListLanguageModelsResponse previousPage) {
            if (previousPage == null) {
                return ListLanguageModelsIterable.this.client.listLanguageModels(ListLanguageModelsIterable.this.firstRequest);
            }
            return ListLanguageModelsIterable.this.client.listLanguageModels((ListLanguageModelsRequest)((Object)ListLanguageModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

