/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.ErrorInfo;
import software.amazon.awssdk.services.tnb.model.StringMapCopier;
import software.amazon.awssdk.services.tnb.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolNetworkOperationTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetSolNetworkOperationTaskDetails> {
    private static final SdkField<Map<String, String>> TASK_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskContext").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskContext)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("taskEndTime").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskEndTime)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ErrorInfo> TASK_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskErrorDetails").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskErrorDetails)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskErrorDetails)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskErrorDetails").build()}).build();
    private static final SdkField<String> TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskName").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskName)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()}).build();
    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("taskStartTime").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskStartTime)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(GetSolNetworkOperationTaskDetails.getter(GetSolNetworkOperationTaskDetails::taskStatusAsString)).setter(GetSolNetworkOperationTaskDetails.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_CONTEXT_FIELD, TASK_END_TIME_FIELD, TASK_ERROR_DETAILS_FIELD, TASK_NAME_FIELD, TASK_START_TIME_FIELD, TASK_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSolNetworkOperationTaskDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> taskContext;
    private final Instant taskEndTime;
    private final ErrorInfo taskErrorDetails;
    private final String taskName;
    private final Instant taskStartTime;
    private final String taskStatus;

    private GetSolNetworkOperationTaskDetails(BuilderImpl builder) {
        this.taskContext = builder.taskContext;
        this.taskEndTime = builder.taskEndTime;
        this.taskErrorDetails = builder.taskErrorDetails;
        this.taskName = builder.taskName;
        this.taskStartTime = builder.taskStartTime;
        this.taskStatus = builder.taskStatus;
    }

    public final boolean hasTaskContext() {
        return this.taskContext != null && !(this.taskContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> taskContext() {
        return this.taskContext;
    }

    public final Instant taskEndTime() {
        return this.taskEndTime;
    }

    public final ErrorInfo taskErrorDetails() {
        return this.taskErrorDetails;
    }

    public final String taskName() {
        return this.taskName;
    }

    public final Instant taskStartTime() {
        return this.taskStartTime;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskContext() ? this.taskContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkOperationTaskDetails)) {
            return false;
        }
        GetSolNetworkOperationTaskDetails other = (GetSolNetworkOperationTaskDetails)obj;
        return this.hasTaskContext() == other.hasTaskContext() && Objects.equals(this.taskContext(), other.taskContext()) && Objects.equals(this.taskEndTime(), other.taskEndTime()) && Objects.equals(this.taskErrorDetails(), other.taskErrorDetails()) && Objects.equals(this.taskName(), other.taskName()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolNetworkOperationTaskDetails").add("TaskContext", this.hasTaskContext() ? this.taskContext() : null).add("TaskEndTime", (Object)this.taskEndTime()).add("TaskErrorDetails", (Object)this.taskErrorDetails()).add("TaskName", (Object)this.taskName()).add("TaskStartTime", (Object)this.taskStartTime()).add("TaskStatus", (Object)this.taskStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskContext": {
                return Optional.ofNullable(clazz.cast(this.taskContext()));
            }
            case "taskEndTime": {
                return Optional.ofNullable(clazz.cast(this.taskEndTime()));
            }
            case "taskErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.taskErrorDetails()));
            }
            case "taskName": {
                return Optional.ofNullable(clazz.cast(this.taskName()));
            }
            case "taskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskContext", TASK_CONTEXT_FIELD);
        map.put("taskEndTime", TASK_END_TIME_FIELD);
        map.put("taskErrorDetails", TASK_ERROR_DETAILS_FIELD);
        map.put("taskName", TASK_NAME_FIELD);
        map.put("taskStartTime", TASK_START_TIME_FIELD);
        map.put("taskStatus", TASK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkOperationTaskDetails, T> g) {
        return obj -> g.apply((GetSolNetworkOperationTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> taskContext = DefaultSdkAutoConstructMap.getInstance();
        private Instant taskEndTime;
        private ErrorInfo taskErrorDetails;
        private String taskName;
        private Instant taskStartTime;
        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkOperationTaskDetails model) {
            this.taskContext(model.taskContext);
            this.taskEndTime(model.taskEndTime);
            this.taskErrorDetails(model.taskErrorDetails);
            this.taskName(model.taskName);
            this.taskStartTime(model.taskStartTime);
            this.taskStatus(model.taskStatus);
        }

        public final Map<String, String> getTaskContext() {
            if (this.taskContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskContext;
        }

        public final void setTaskContext(Map<String, String> taskContext) {
            this.taskContext = StringMapCopier.copy(taskContext);
        }

        @Override
        public final Builder taskContext(Map<String, String> taskContext) {
            this.taskContext = StringMapCopier.copy(taskContext);
            return this;
        }

        public final Instant getTaskEndTime() {
            return this.taskEndTime;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final ErrorInfo.Builder getTaskErrorDetails() {
            return this.taskErrorDetails != null ? this.taskErrorDetails.toBuilder() : null;
        }

        public final void setTaskErrorDetails(ErrorInfo.BuilderImpl taskErrorDetails) {
            this.taskErrorDetails = taskErrorDetails != null ? taskErrorDetails.build() : null;
        }

        @Override
        public final Builder taskErrorDetails(ErrorInfo taskErrorDetails) {
            this.taskErrorDetails = taskErrorDetails;
            return this;
        }

        public final String getTaskName() {
            return this.taskName;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public GetSolNetworkOperationTaskDetails build() {
            return new GetSolNetworkOperationTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetSolNetworkOperationTaskDetails> {
        public Builder taskContext(Map<String, String> var1);

        public Builder taskEndTime(Instant var1);

        public Builder taskErrorDetails(ErrorInfo var1);

        default public Builder taskErrorDetails(Consumer<ErrorInfo.Builder> taskErrorDetails) {
            return this.taskErrorDetails((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(taskErrorDetails)).build());
        }

        public Builder taskName(String var1);

        public Builder taskStartTime(Instant var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);
    }
}

