/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists information about a network function instance.
 * </p>
 * <p>
 * A network function instance is a function in a function package .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolFunctionInstanceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSolFunctionInstanceInfo.Builder, ListSolFunctionInstanceInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListSolFunctionInstanceInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ListSolFunctionInstanceInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<GetSolInstantiatedVnfInfo> INSTANTIATED_VNF_INFO_FIELD = SdkField
            .<GetSolInstantiatedVnfInfo> builder(MarshallingType.SDK_POJO).memberName("instantiatedVnfInfo")
            .getter(getter(ListSolFunctionInstanceInfo::instantiatedVnfInfo)).setter(setter(Builder::instantiatedVnfInfo))
            .constructor(GetSolInstantiatedVnfInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiatedVnfInfo").build())
            .build();

    private static final SdkField<String> INSTANTIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instantiationState").getter(getter(ListSolFunctionInstanceInfo::instantiationStateAsString))
            .setter(setter(Builder::instantiationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiationState").build())
            .build();

    private static final SdkField<ListSolFunctionInstanceMetadata> METADATA_FIELD = SdkField
            .<ListSolFunctionInstanceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(ListSolFunctionInstanceInfo::metadata)).setter(setter(Builder::metadata))
            .constructor(ListSolFunctionInstanceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(ListSolFunctionInstanceInfo::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()).build();

    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfPkgId").getter(getter(ListSolFunctionInstanceInfo::vnfPkgId)).setter(setter(Builder::vnfPkgId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgId").build()).build();

    private static final SdkField<String> VNF_PKG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfPkgName").getter(getter(ListSolFunctionInstanceInfo::vnfPkgName)).setter(setter(Builder::vnfPkgName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            INSTANTIATED_VNF_INFO_FIELD, INSTANTIATION_STATE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, VNF_PKG_ID_FIELD,
            VNF_PKG_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final GetSolInstantiatedVnfInfo instantiatedVnfInfo;

    private final String instantiationState;

    private final ListSolFunctionInstanceMetadata metadata;

    private final String nsInstanceId;

    private final String vnfPkgId;

    private final String vnfPkgName;

    private ListSolFunctionInstanceInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.instantiatedVnfInfo = builder.instantiatedVnfInfo;
        this.instantiationState = builder.instantiationState;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.vnfPkgId = builder.vnfPkgId;
        this.vnfPkgName = builder.vnfPkgName;
    }

    /**
     * <p>
     * Network function instance ARN.
     * </p>
     * 
     * @return Network function instance ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network function instance ID.
     * </p>
     * 
     * @return Network function instance ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the InstantiatedVnfInfo property for this object.
     * 
     * @return The value of the InstantiatedVnfInfo property for this object.
     */
    public final GetSolInstantiatedVnfInfo instantiatedVnfInfo() {
        return instantiatedVnfInfo;
    }

    /**
     * <p>
     * Network function instance instantiation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instantiationState} will return {@link VnfInstantiationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instantiationStateAsString}.
     * </p>
     * 
     * @return Network function instance instantiation state.
     * @see VnfInstantiationState
     */
    public final VnfInstantiationState instantiationState() {
        return VnfInstantiationState.fromValue(instantiationState);
    }

    /**
     * <p>
     * Network function instance instantiation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instantiationState} will return {@link VnfInstantiationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instantiationStateAsString}.
     * </p>
     * 
     * @return Network function instance instantiation state.
     * @see VnfInstantiationState
     */
    public final String instantiationStateAsString() {
        return instantiationState;
    }

    /**
     * <p>
     * Network function instance metadata.
     * </p>
     * 
     * @return Network function instance metadata.
     */
    public final ListSolFunctionInstanceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Network instance ID.
     * </p>
     * 
     * @return Network instance ID.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * <p>
     * Function package ID.
     * </p>
     * 
     * @return Function package ID.
     */
    public final String vnfPkgId() {
        return vnfPkgId;
    }

    /**
     * <p>
     * Function package name.
     * </p>
     * 
     * @return Function package name.
     */
    public final String vnfPkgName() {
        return vnfPkgName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instantiatedVnfInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instantiationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfPkgId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfPkgName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolFunctionInstanceInfo)) {
            return false;
        }
        ListSolFunctionInstanceInfo other = (ListSolFunctionInstanceInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(instantiatedVnfInfo(), other.instantiatedVnfInfo())
                && Objects.equals(instantiationStateAsString(), other.instantiationStateAsString())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsInstanceId(), other.nsInstanceId())
                && Objects.equals(vnfPkgId(), other.vnfPkgId()) && Objects.equals(vnfPkgName(), other.vnfPkgName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolFunctionInstanceInfo").add("Arn", arn()).add("Id", id())
                .add("InstantiatedVnfInfo", instantiatedVnfInfo()).add("InstantiationState", instantiationStateAsString())
                .add("Metadata", metadata()).add("NsInstanceId", nsInstanceId()).add("VnfPkgId", vnfPkgId())
                .add("VnfPkgName", vnfPkgName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "instantiatedVnfInfo":
            return Optional.ofNullable(clazz.cast(instantiatedVnfInfo()));
        case "instantiationState":
            return Optional.ofNullable(clazz.cast(instantiationStateAsString()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "vnfPkgId":
            return Optional.ofNullable(clazz.cast(vnfPkgId()));
        case "vnfPkgName":
            return Optional.ofNullable(clazz.cast(vnfPkgName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolFunctionInstanceInfo, T> g) {
        return obj -> g.apply((ListSolFunctionInstanceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSolFunctionInstanceInfo> {
        /**
         * <p>
         * Network function instance ARN.
         * </p>
         * 
         * @param arn
         *        Network function instance ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network function instance ID.
         * </p>
         * 
         * @param id
         *        Network function instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the InstantiatedVnfInfo property for this object.
         *
         * @param instantiatedVnfInfo
         *        The new value for the InstantiatedVnfInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instantiatedVnfInfo(GetSolInstantiatedVnfInfo instantiatedVnfInfo);

        /**
         * Sets the value of the InstantiatedVnfInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolInstantiatedVnfInfo.Builder}
         * avoiding the need to create one manually via {@link GetSolInstantiatedVnfInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolInstantiatedVnfInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #instantiatedVnfInfo(GetSolInstantiatedVnfInfo)}.
         * 
         * @param instantiatedVnfInfo
         *        a consumer that will call methods on {@link GetSolInstantiatedVnfInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instantiatedVnfInfo(GetSolInstantiatedVnfInfo)
         */
        default Builder instantiatedVnfInfo(Consumer<GetSolInstantiatedVnfInfo.Builder> instantiatedVnfInfo) {
            return instantiatedVnfInfo(GetSolInstantiatedVnfInfo.builder().applyMutation(instantiatedVnfInfo).build());
        }

        /**
         * <p>
         * Network function instance instantiation state.
         * </p>
         * 
         * @param instantiationState
         *        Network function instance instantiation state.
         * @see VnfInstantiationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfInstantiationState
         */
        Builder instantiationState(String instantiationState);

        /**
         * <p>
         * Network function instance instantiation state.
         * </p>
         * 
         * @param instantiationState
         *        Network function instance instantiation state.
         * @see VnfInstantiationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfInstantiationState
         */
        Builder instantiationState(VnfInstantiationState instantiationState);

        /**
         * <p>
         * Network function instance metadata.
         * </p>
         * 
         * @param metadata
         *        Network function instance metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ListSolFunctionInstanceMetadata metadata);

        /**
         * <p>
         * Network function instance metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListSolFunctionInstanceMetadata.Builder}
         * avoiding the need to create one manually via {@link ListSolFunctionInstanceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListSolFunctionInstanceMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(ListSolFunctionInstanceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ListSolFunctionInstanceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ListSolFunctionInstanceMetadata)
         */
        default Builder metadata(Consumer<ListSolFunctionInstanceMetadata.Builder> metadata) {
            return metadata(ListSolFunctionInstanceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Network instance ID.
         * </p>
         * 
         * @param nsInstanceId
         *        Network instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * Function package ID.
         * </p>
         * 
         * @param vnfPkgId
         *        Function package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgId(String vnfPkgId);

        /**
         * <p>
         * Function package name.
         * </p>
         * 
         * @param vnfPkgName
         *        Function package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgName(String vnfPkgName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private GetSolInstantiatedVnfInfo instantiatedVnfInfo;

        private String instantiationState;

        private ListSolFunctionInstanceMetadata metadata;

        private String nsInstanceId;

        private String vnfPkgId;

        private String vnfPkgName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolFunctionInstanceInfo model) {
            arn(model.arn);
            id(model.id);
            instantiatedVnfInfo(model.instantiatedVnfInfo);
            instantiationState(model.instantiationState);
            metadata(model.metadata);
            nsInstanceId(model.nsInstanceId);
            vnfPkgId(model.vnfPkgId);
            vnfPkgName(model.vnfPkgName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolInstantiatedVnfInfo.Builder getInstantiatedVnfInfo() {
            return instantiatedVnfInfo != null ? instantiatedVnfInfo.toBuilder() : null;
        }

        public final void setInstantiatedVnfInfo(GetSolInstantiatedVnfInfo.BuilderImpl instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo != null ? instantiatedVnfInfo.build() : null;
        }

        @Override
        public final Builder instantiatedVnfInfo(GetSolInstantiatedVnfInfo instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo;
            return this;
        }

        public final String getInstantiationState() {
            return instantiationState;
        }

        public final void setInstantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
        }

        @Override
        public final Builder instantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
            return this;
        }

        @Override
        public final Builder instantiationState(VnfInstantiationState instantiationState) {
            this.instantiationState(instantiationState == null ? null : instantiationState.toString());
            return this;
        }

        public final ListSolFunctionInstanceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolFunctionInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolFunctionInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getVnfPkgId() {
            return vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        public final String getVnfPkgName() {
            return vnfPkgName;
        }

        public final void setVnfPkgName(String vnfPkgName) {
            this.vnfPkgName = vnfPkgName;
        }

        @Override
        public final Builder vnfPkgName(String vnfPkgName) {
            this.vnfPkgName = vnfPkgName;
            return this;
        }

        @Override
        public ListSolFunctionInstanceInfo build() {
            return new ListSolFunctionInstanceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
