/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata related to the function package.
 * </p>
 * <p>
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI
 * standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how
 * the network functions should run on your network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolFunctionPackageMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSolFunctionPackageMetadata.Builder, GetSolFunctionPackageMetadata> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetSolFunctionPackageMetadata::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified")
            .getter(getter(GetSolFunctionPackageMetadata::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<FunctionArtifactMeta> VNFD_FIELD = SdkField
            .<FunctionArtifactMeta> builder(MarshallingType.SDK_POJO).memberName("vnfd")
            .getter(getter(GetSolFunctionPackageMetadata::vnfd)).setter(setter(Builder::vnfd))
            .constructor(FunctionArtifactMeta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfd").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            LAST_MODIFIED_FIELD, VNFD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Instant lastModified;

    private final FunctionArtifactMeta vnfd;

    private GetSolFunctionPackageMetadata(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.lastModified = builder.lastModified;
        this.vnfd = builder.vnfd;
    }

    /**
     * <p>
     * The date that the resource was created.
     * </p>
     * 
     * @return The date that the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date that the resource was last modified.
     * </p>
     * 
     * @return The date that the resource was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * Metadata related to the function package descriptor of the function package.
     * </p>
     * 
     * @return Metadata related to the function package descriptor of the function package.
     */
    public final FunctionArtifactMeta vnfd() {
        return vnfd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(vnfd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageMetadata)) {
            return false;
        }
        GetSolFunctionPackageMetadata other = (GetSolFunctionPackageMetadata) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(vnfd(), other.vnfd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolFunctionPackageMetadata").add("CreatedAt", createdAt())
                .add("LastModified", lastModified()).add("Vnfd", vnfd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "vnfd":
            return Optional.ofNullable(clazz.cast(vnfd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageMetadata, T> g) {
        return obj -> g.apply((GetSolFunctionPackageMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSolFunctionPackageMetadata> {
        /**
         * <p>
         * The date that the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date that the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date that the resource was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date that the resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * Metadata related to the function package descriptor of the function package.
         * </p>
         * 
         * @param vnfd
         *        Metadata related to the function package descriptor of the function package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfd(FunctionArtifactMeta vnfd);

        /**
         * <p>
         * Metadata related to the function package descriptor of the function package.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionArtifactMeta.Builder} avoiding
         * the need to create one manually via {@link FunctionArtifactMeta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionArtifactMeta.Builder#build()} is called immediately and
         * its result is passed to {@link #vnfd(FunctionArtifactMeta)}.
         * 
         * @param vnfd
         *        a consumer that will call methods on {@link FunctionArtifactMeta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vnfd(FunctionArtifactMeta)
         */
        default Builder vnfd(Consumer<FunctionArtifactMeta.Builder> vnfd) {
            return vnfd(FunctionArtifactMeta.builder().applyMutation(vnfd).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant lastModified;

        private FunctionArtifactMeta vnfd;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageMetadata model) {
            createdAt(model.createdAt);
            lastModified(model.lastModified);
            vnfd(model.vnfd);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final FunctionArtifactMeta.Builder getVnfd() {
            return vnfd != null ? vnfd.toBuilder() : null;
        }

        public final void setVnfd(FunctionArtifactMeta.BuilderImpl vnfd) {
            this.vnfd = vnfd != null ? vnfd.build() : null;
        }

        @Override
        public final Builder vnfd(FunctionArtifactMeta vnfd) {
            this.vnfd = vnfd;
            return this;
        }

        @Override
        public GetSolFunctionPackageMetadata build() {
            return new GetSolFunctionPackageMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
