/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Report configuration for a batch load task. This contains details about where error reports are stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportConfiguration.Builder, ReportConfiguration> {
    private static final SdkField<ReportS3Configuration> REPORT_S3_CONFIGURATION_FIELD = SdkField
            .<ReportS3Configuration> builder(MarshallingType.SDK_POJO).memberName("ReportS3Configuration")
            .getter(getter(ReportConfiguration::reportS3Configuration)).setter(setter(Builder::reportS3Configuration))
            .constructor(ReportS3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportS3Configuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(REPORT_S3_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReportS3Configuration reportS3Configuration;

    private ReportConfiguration(BuilderImpl builder) {
        this.reportS3Configuration = builder.reportS3Configuration;
    }

    /**
     * <p>
     * Configuration of an S3 location to write error reports and events for a batch load.
     * </p>
     * 
     * @return Configuration of an S3 location to write error reports and events for a batch load.
     */
    public final ReportS3Configuration reportS3Configuration() {
        return reportS3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportS3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportConfiguration)) {
            return false;
        }
        ReportConfiguration other = (ReportConfiguration) obj;
        return Objects.equals(reportS3Configuration(), other.reportS3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportConfiguration").add("ReportS3Configuration", reportS3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportS3Configuration":
            return Optional.ofNullable(clazz.cast(reportS3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportS3Configuration", REPORT_S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportConfiguration, T> g) {
        return obj -> g.apply((ReportConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportConfiguration> {
        /**
         * <p>
         * Configuration of an S3 location to write error reports and events for a batch load.
         * </p>
         * 
         * @param reportS3Configuration
         *        Configuration of an S3 location to write error reports and events for a batch load.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportS3Configuration(ReportS3Configuration reportS3Configuration);

        /**
         * <p>
         * Configuration of an S3 location to write error reports and events for a batch load.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportS3Configuration.Builder} avoiding
         * the need to create one manually via {@link ReportS3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportS3Configuration.Builder#build()} is called immediately and
         * its result is passed to {@link #reportS3Configuration(ReportS3Configuration)}.
         * 
         * @param reportS3Configuration
         *        a consumer that will call methods on {@link ReportS3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportS3Configuration(ReportS3Configuration)
         */
        default Builder reportS3Configuration(Consumer<ReportS3Configuration.Builder> reportS3Configuration) {
            return reportS3Configuration(ReportS3Configuration.builder().applyMutation(reportS3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReportS3Configuration reportS3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportConfiguration model) {
            reportS3Configuration(model.reportS3Configuration);
        }

        public final ReportS3Configuration.Builder getReportS3Configuration() {
            return reportS3Configuration != null ? reportS3Configuration.toBuilder() : null;
        }

        public final void setReportS3Configuration(ReportS3Configuration.BuilderImpl reportS3Configuration) {
            this.reportS3Configuration = reportS3Configuration != null ? reportS3Configuration.build() : null;
        }

        @Override
        public final Builder reportS3Configuration(ReportS3Configuration reportS3Configuration) {
            this.reportS3Configuration = reportS3Configuration;
            return this;
        }

        @Override
        public ReportConfiguration build() {
            return new ReportConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
