/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the records ingested by this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordsIngested implements SdkPojo, Serializable, ToCopyableBuilder<RecordsIngested.Builder, RecordsIngested> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Total")
            .getter(getter(RecordsIngested::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<Integer> MEMORY_STORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryStore").getter(getter(RecordsIngested::memoryStore)).setter(setter(Builder::memoryStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryStore").build()).build();

    private static final SdkField<Integer> MAGNETIC_STORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MagneticStore").getter(getter(RecordsIngested::magneticStore)).setter(setter(Builder::magneticStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD,
            MEMORY_STORE_FIELD, MAGNETIC_STORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer total;

    private final Integer memoryStore;

    private final Integer magneticStore;

    private RecordsIngested(BuilderImpl builder) {
        this.total = builder.total;
        this.memoryStore = builder.memoryStore;
        this.magneticStore = builder.magneticStore;
    }

    /**
     * <p>
     * Total count of successfully ingested records.
     * </p>
     * 
     * @return Total count of successfully ingested records.
     */
    public final Integer total() {
        return total;
    }

    /**
     * <p>
     * Count of records ingested into the memory store.
     * </p>
     * 
     * @return Count of records ingested into the memory store.
     */
    public final Integer memoryStore() {
        return memoryStore;
    }

    /**
     * <p>
     * Count of records ingested into the magnetic store.
     * </p>
     * 
     * @return Count of records ingested into the magnetic store.
     */
    public final Integer magneticStore() {
        return magneticStore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(memoryStore());
        hashCode = 31 * hashCode + Objects.hashCode(magneticStore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordsIngested)) {
            return false;
        }
        RecordsIngested other = (RecordsIngested) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(memoryStore(), other.memoryStore())
                && Objects.equals(magneticStore(), other.magneticStore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordsIngested").add("Total", total()).add("MemoryStore", memoryStore())
                .add("MagneticStore", magneticStore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "MemoryStore":
            return Optional.ofNullable(clazz.cast(memoryStore()));
        case "MagneticStore":
            return Optional.ofNullable(clazz.cast(magneticStore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Total", TOTAL_FIELD);
        map.put("MemoryStore", MEMORY_STORE_FIELD);
        map.put("MagneticStore", MAGNETIC_STORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordsIngested, T> g) {
        return obj -> g.apply((RecordsIngested) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordsIngested> {
        /**
         * <p>
         * Total count of successfully ingested records.
         * </p>
         * 
         * @param total
         *        Total count of successfully ingested records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * Count of records ingested into the memory store.
         * </p>
         * 
         * @param memoryStore
         *        Count of records ingested into the memory store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStore(Integer memoryStore);

        /**
         * <p>
         * Count of records ingested into the magnetic store.
         * </p>
         * 
         * @param magneticStore
         *        Count of records ingested into the magnetic store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStore(Integer magneticStore);
    }

    static final class BuilderImpl implements Builder {
        private Integer total;

        private Integer memoryStore;

        private Integer magneticStore;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordsIngested model) {
            total(model.total);
            memoryStore(model.memoryStore);
            magneticStore(model.magneticStore);
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getMemoryStore() {
            return memoryStore;
        }

        public final void setMemoryStore(Integer memoryStore) {
            this.memoryStore = memoryStore;
        }

        @Override
        public final Builder memoryStore(Integer memoryStore) {
            this.memoryStore = memoryStore;
            return this;
        }

        public final Integer getMagneticStore() {
            return magneticStore;
        }

        public final void setMagneticStore(Integer magneticStore) {
            this.magneticStore = magneticStore;
        }

        @Override
        public final Builder magneticStore(Integer magneticStore) {
            this.magneticStore = magneticStore;
            return this;
        }

        @Override
        public RecordsIngested build() {
            return new RecordsIngested(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
