/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchLoadTasksRequest extends TimestreamWriteRequest implements
        ToCopyableBuilder<ListBatchLoadTasksRequest.Builder, ListBatchLoadTasksRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBatchLoadTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBatchLoadTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskStatus").getter(getter(ListBatchLoadTasksRequest::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, TASK_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String taskStatus;

    private ListBatchLoadTasksRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.taskStatus = builder.taskStatus;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of items to return in the output. If the total number of items available is more than the value
     * specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument
     * of a subsequent API invocation.
     * </p>
     * 
     * @return The total number of items to return in the output. If the total number of items available is more than
     *         the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken
     *         value as argument of a subsequent API invocation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final BatchLoadStatus taskStatus() {
        return BatchLoadStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchLoadTasksRequest)) {
            return false;
        }
        ListBatchLoadTasksRequest other = (ListBatchLoadTasksRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchLoadTasksRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("TaskStatus", taskStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "TaskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("TaskStatus", TASK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchLoadTasksRequest, T> g) {
        return obj -> g.apply((ListBatchLoadTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBatchLoadTasksRequest> {
        /**
         * <p>
         * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the NextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of items to return in the output. If the total number of items available is more than the
         * value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as
         * argument of a subsequent API invocation.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return in the output. If the total number of items available is more than
         *        the value specified, a NextToken is provided in the output. To resume pagination, provide the
         *        NextToken value as argument of a subsequent API invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(BatchLoadStatus taskStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamWriteRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchLoadTasksRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            taskStatus(model.taskStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(BatchLoadStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBatchLoadTasksRequest build() {
            return new ListBatchLoadTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
