/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties;
import software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties;
import software.amazon.awssdk.services.timestreamwrite.model.Schema;
import software.amazon.awssdk.services.timestreamwrite.model.TableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Table
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Table> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Table.getter(Table::arn)).setter(Table.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(Table.getter(Table::tableName)).setter(Table.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(Table.getter(Table::databaseName)).setter(Table.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableStatus").getter(Table.getter(Table::tableStatusAsString)).setter(Table.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()}).build();
    private static final SdkField<RetentionProperties> RETENTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionProperties").getter(Table.getter(Table::retentionProperties)).setter(Table.setter(Builder::retentionProperties)).constructor(RetentionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionProperties").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Table.getter(Table::creationTime)).setter(Table.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Table.getter(Table::lastUpdatedTime)).setter(Table.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<MagneticStoreWriteProperties> MAGNETIC_STORE_WRITE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MagneticStoreWriteProperties").getter(Table.getter(Table::magneticStoreWriteProperties)).setter(Table.setter(Builder::magneticStoreWriteProperties)).constructor(MagneticStoreWriteProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreWriteProperties").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(Table.getter(Table::schema)).setter(Table.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TABLE_NAME_FIELD, DATABASE_NAME_FIELD, TABLE_STATUS_FIELD, RETENTION_PROPERTIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, MAGNETIC_STORE_WRITE_PROPERTIES_FIELD, SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Table.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String tableName;
    private final String databaseName;
    private final String tableStatus;
    private final RetentionProperties retentionProperties;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final MagneticStoreWriteProperties magneticStoreWriteProperties;
    private final Schema schema;

    private Table(BuilderImpl builder) {
        this.arn = builder.arn;
        this.tableName = builder.tableName;
        this.databaseName = builder.databaseName;
        this.tableStatus = builder.tableStatus;
        this.retentionProperties = builder.retentionProperties;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
        this.schema = builder.schema;
    }

    public final String arn() {
        return this.arn;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final TableStatus tableStatus() {
        return TableStatus.fromValue(this.tableStatus);
    }

    public final String tableStatusAsString() {
        return this.tableStatus;
    }

    public final RetentionProperties retentionProperties() {
        return this.retentionProperties;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final MagneticStoreWriteProperties magneticStoreWriteProperties() {
        return this.magneticStoreWriteProperties;
    }

    public final Schema schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.magneticStoreWriteProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableStatusAsString(), other.tableStatusAsString()) && Objects.equals(this.retentionProperties(), other.retentionProperties()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.magneticStoreWriteProperties(), other.magneticStoreWriteProperties()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"Table").add("Arn", (Object)this.arn()).add("TableName", (Object)this.tableName()).add("DatabaseName", (Object)this.databaseName()).add("TableStatus", (Object)this.tableStatusAsString()).add("RetentionProperties", (Object)this.retentionProperties()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("MagneticStoreWriteProperties", (Object)this.magneticStoreWriteProperties()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatusAsString()));
            }
            case "RetentionProperties": {
                return Optional.ofNullable(clazz.cast(this.retentionProperties()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "MagneticStoreWriteProperties": {
                return Optional.ofNullable(clazz.cast(this.magneticStoreWriteProperties()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableStatus", TABLE_STATUS_FIELD);
        map.put("RetentionProperties", RETENTION_PROPERTIES_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("MagneticStoreWriteProperties", MAGNETIC_STORE_WRITE_PROPERTIES_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String tableName;
        private String databaseName;
        private String tableStatus;
        private RetentionProperties retentionProperties;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private MagneticStoreWriteProperties magneticStoreWriteProperties;
        private Schema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            this.arn(model.arn);
            this.tableName(model.tableName);
            this.databaseName(model.databaseName);
            this.tableStatus(model.tableStatus);
            this.retentionProperties(model.retentionProperties);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.magneticStoreWriteProperties(model.magneticStoreWriteProperties);
            this.schema(model.schema);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final RetentionProperties.Builder getRetentionProperties() {
            return this.retentionProperties != null ? this.retentionProperties.toBuilder() : null;
        }

        public final void setRetentionProperties(RetentionProperties.BuilderImpl retentionProperties) {
            this.retentionProperties = retentionProperties != null ? retentionProperties.build() : null;
        }

        @Override
        public final Builder retentionProperties(RetentionProperties retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final MagneticStoreWriteProperties.Builder getMagneticStoreWriteProperties() {
            return this.magneticStoreWriteProperties != null ? this.magneticStoreWriteProperties.toBuilder() : null;
        }

        public final void setMagneticStoreWriteProperties(MagneticStoreWriteProperties.BuilderImpl magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties != null ? magneticStoreWriteProperties.build() : null;
        }

        @Override
        public final Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Table build() {
            return new Table(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Table> {
        public Builder arn(String var1);

        public Builder tableName(String var1);

        public Builder databaseName(String var1);

        public Builder tableStatus(String var1);

        public Builder tableStatus(TableStatus var1);

        public Builder retentionProperties(RetentionProperties var1);

        default public Builder retentionProperties(Consumer<RetentionProperties.Builder> retentionProperties) {
            return this.retentionProperties((RetentionProperties)((RetentionProperties.Builder)RetentionProperties.builder().applyMutation(retentionProperties)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder magneticStoreWriteProperties(MagneticStoreWriteProperties var1);

        default public Builder magneticStoreWriteProperties(Consumer<MagneticStoreWriteProperties.Builder> magneticStoreWriteProperties) {
            return this.magneticStoreWriteProperties((MagneticStoreWriteProperties)((MagneticStoreWriteProperties.Builder)MagneticStoreWriteProperties.builder().applyMutation(magneticStoreWriteProperties)).build());
        }

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }
    }
}

