/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse;

public class ListBatchLoadTasksPublisher
implements SdkPublisher<ListBatchLoadTasksResponse> {
    private final TimestreamWriteAsyncClient client;
    private final ListBatchLoadTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBatchLoadTasksPublisher(TimestreamWriteAsyncClient client, ListBatchLoadTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBatchLoadTasksPublisher(TimestreamWriteAsyncClient client, ListBatchLoadTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBatchLoadTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBatchLoadTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBatchLoadTasksResponseFetcher
    implements AsyncPageFetcher<ListBatchLoadTasksResponse> {
        private ListBatchLoadTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchLoadTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBatchLoadTasksResponse> nextPage(ListBatchLoadTasksResponse previousPage) {
            if (previousPage == null) {
                return ListBatchLoadTasksPublisher.this.client.listBatchLoadTasks(ListBatchLoadTasksPublisher.this.firstRequest);
            }
            return ListBatchLoadTasksPublisher.this.client.listBatchLoadTasks((ListBatchLoadTasksRequest)((Object)ListBatchLoadTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

