/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable;

/**
 * Service client for accessing Timestream Write. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Timestream Write</fullname>
 * <p>
 * Amazon Timestream is a fast, scalable, fully managed time-series database service that makes it easy to store and
 * analyze trillions of time-series data points per day. With Timestream, you can easily store and analyze IoT sensor
 * data to derive insights from your IoT applications. You can analyze industrial telemetry to streamline equipment
 * management and maintenance. You can also store and analyze log data and metrics to improve the performance and
 * availability of your applications.
 * </p>
 * <p>
 * Timestream is built from the ground up to effectively ingest, process, and store time-series data. It organizes data
 * to optimize query processing. It automatically scales based on the volume of data ingested and on the query volume to
 * ensure you receive optimal performance while inserting and querying data. As your data grows over time, Timestream’s
 * adaptive query processing engine spans across storage tiers to provide fast analysis while reducing costs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TimestreamWriteClient extends AwsClient {
    String SERVICE_NAME = "timestream";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ingest.timestream";

    /**
     * <p>
     * Creates a new Timestream batch load task. A batch load task processes data from a CSV source in an S3 location
     * and writes to a Timestream table. A mapping from source to target is defined in a batch load task. Errors and
     * events are written to a report at an S3 location. For the report, if the KMS key is not specified, the batch load
     * task will be encrypted with a Timestream managed KMS key located in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service
     * quotas apply</a>. For details, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html">code
     * sample</a>.
     * </p>
     *
     * @param createBatchLoadTaskRequest
     * @return Result of the CreateBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchLoadTaskResponse createBatchLoadTask(CreateBatchLoadTaskRequest createBatchLoadTaskRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, InvalidEndpointException, AwsServiceException,
            SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Timestream batch load task. A batch load task processes data from a CSV source in an S3 location
     * and writes to a Timestream table. A mapping from source to target is defined in a batch load task. Errors and
     * events are written to a report at an S3 location. For the report, if the KMS key is not specified, the batch load
     * task will be encrypted with a Timestream managed KMS key located in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service
     * quotas apply</a>. For details, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html">code
     * sample</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchLoadTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBatchLoadTaskRequest#builder()}
     * </p>
     *
     * @param createBatchLoadTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchLoadTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchLoadTaskResponse createBatchLoadTask(
            Consumer<CreateBatchLoadTaskRequest.Builder> createBatchLoadTaskRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException,
            ServiceQuotaExceededException, InvalidEndpointException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return createBatchLoadTask(CreateBatchLoadTaskRequest.builder().applyMutation(createBatchLoadTaskRequest).build());
    }

    /**
     * <p>
     * Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a
     * Timestream managed KMS key located in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service
     * quotas apply</a>. For details, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html">code sample</a>.
     * </p>
     *
     * @param createDatabaseRequest
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException,
            InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a
     * Timestream managed KMS key located in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service
     * quotas apply</a>. For details, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html">code sample</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatabaseRequest#builder()}
     * </p>
     *
     * @param createDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatabaseRequest.Builder} to create a request.
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatabaseResponse createDatabase(Consumer<CreateDatabaseRequest.Builder> createDatabaseRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException,
            ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return createDatabase(CreateDatabaseRequest.builder().applyMutation(createDatabaseRequest).build());
    }

    /**
     * <p>
     * Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be
     * at least unique within each Region if they are in the same database. You might have identical table names in the
     * same Region if the tables are in separate databases. While creating the table, you must specify the table name,
     * database name, and the retention properties. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code
     * sample</a> for details.
     * </p>
     *
     * @param createTableRequest
     * @return Result of the CreateTable operation returned by the service.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException,
            InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be
     * at least unique within each Region if they are in the same database. You might have identical table names in the
     * same Region if the tables are in separate databases. While creating the table, you must specify the table name,
     * database name, and the retention properties. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on {@link CreateTableRequest.Builder} to create a request.
     * @return Result of the CreateTable operation returned by the service.
     * @throws ConflictException
     *         Timestream was unable to process this request because it contains resource that already exists.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTableResponse createTable(Consumer<CreateTableRequest.Builder> createTableRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Deletes a given Timestream database. <i>This is an irreversible operation. After a database is deleted, the
     * time-series data from its tables cannot be recovered.</i>
     * </p>
     * <note>
     * <p>
     * All tables in the database must be deleted first, or a ValidationException error will be thrown.
     * </p>
     * <p>
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException.
     * Clients should consider them equivalent.
     * </p>
     * </note>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html">code
     * sample</a> for details.
     * </p>
     *
     * @param deleteDatabaseRequest
     * @return Result of the DeleteDatabase operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DeleteDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given Timestream database. <i>This is an irreversible operation. After a database is deleted, the
     * time-series data from its tables cannot be recovered.</i>
     * </p>
     * <note>
     * <p>
     * All tables in the database must be deleted first, or a ValidationException error will be thrown.
     * </p>
     * <p>
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException.
     * Clients should consider them equivalent.
     * </p>
     * </note>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatabaseRequest.Builder} to create a request.
     * @return Result of the DeleteDatabase operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DeleteDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatabaseResponse deleteDatabase(Consumer<DeleteDatabaseRequest.Builder> deleteDatabaseRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return deleteDatabase(DeleteDatabaseRequest.builder().applyMutation(deleteDatabaseRequest).build());
    }

    /**
     * <p>
     * Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is
     * deleted, the time-series data stored in the table cannot be recovered.
     * </p>
     * <note>
     * <p>
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException.
     * Clients should consider them equivalent.
     * </p>
     * </note>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html">code
     * sample</a> for details.
     * </p>
     *
     * @param deleteTableRequest
     * @return Result of the DeleteTable operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is
     * deleted, the time-series data stored in the table cannot be recovered.
     * </p>
     * <note>
     * <p>
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException.
     * Clients should consider them equivalent.
     * </p>
     * </note>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTableRequest.Builder} to create a request.
     * @return Result of the DeleteTable operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTableResponse deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Returns information about the batch load task, including configurations, mappings, progress, and other details.
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>.
     * See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html">code
     * sample</a> for details.
     * </p>
     *
     * @param describeBatchLoadTaskRequest
     * @return Result of the DescribeBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchLoadTaskResponse describeBatchLoadTask(DescribeBatchLoadTaskRequest describeBatchLoadTaskRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the batch load task, including configurations, mappings, progress, and other details.
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>.
     * See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBatchLoadTaskRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBatchLoadTaskRequest#builder()}
     * </p>
     *
     * @param describeBatchLoadTaskRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBatchLoadTaskRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchLoadTaskResponse describeBatchLoadTask(
            Consumer<DescribeBatchLoadTaskRequest.Builder> describeBatchLoadTaskRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException,
            SdkClientException, TimestreamWriteException {
        return describeBatchLoadTask(DescribeBatchLoadTaskRequest.builder().applyMutation(describeBatchLoadTaskRequest).build());
    }

    /**
     * <p>
     * Returns information about the database, including the database name, time that the database was created, and the
     * total number of tables found within the database. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html">code
     * sample</a> for details.
     * </p>
     *
     * @param describeDatabaseRequest
     * @return Result of the DescribeDatabase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatabaseResponse describeDatabase(DescribeDatabaseRequest describeDatabaseRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException,
            InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the database, including the database name, time that the database was created, and the
     * total number of tables found within the database. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatabaseRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatabaseRequest#builder()}
     * </p>
     *
     * @param describeDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatabaseRequest.Builder} to create a request.
     * @return Result of the DescribeDatabase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatabaseResponse describeDatabase(Consumer<DescribeDatabaseRequest.Builder> describeDatabaseRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException,
            InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return describeDatabase(DescribeDatabaseRequest.builder().applyMutation(describeDatabaseRequest).build());
    }

    /**
     * <p>
     * Returns a list of available endpoints to make Timestream API calls against. This API operation is available
     * through both the Write and Query APIs.
     * </p>
     * <p>
     * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the
     * management and mapping of the service endpoints, <i>we don't recommend that you use this API operation
     * unless</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are using <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints">VPC endpoints
     * (Amazon Web Services PrivateLink) with Timestream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Your application uses a programming language that does not yet have SDK support
     * </p>
     * </li>
     * <li>
     * <p>
     * You require better control over the client-side implementation
     * </p>
     * </li>
     * </ul>
     * <p>
     * For detailed information on how and when to use and implement DescribeEndpoints, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery"
     * >The Endpoint Discovery Pattern</a>.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of available endpoints to make Timestream API calls against. This API operation is available
     * through both the Write and Query APIs.
     * </p>
     * <p>
     * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the
     * management and mapping of the service endpoints, <i>we don't recommend that you use this API operation
     * unless</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are using <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints">VPC endpoints
     * (Amazon Web Services PrivateLink) with Timestream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * Your application uses a programming language that does not yet have SDK support
     * </p>
     * </li>
     * <li>
     * <p>
     * You require better control over the client-side implementation
     * </p>
     * </li>
     * </ul>
     * <p>
     * For detailed information on how and when to use and implement DescribeEndpoints, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery"
     * >The Endpoint Discovery Pattern</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointsRequest.Builder} to create a request.
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the table, including the table name, database name, retention duration of the memory
     * store and the magnetic store. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html">code
     * sample</a> for details.
     * </p>
     *
     * @param describeTableRequest
     * @return Result of the DescribeTable operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the table, including the table name, database name, retention duration of the memory
     * store and the magnetic store. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRequest.Builder} to create a request.
     * @return Result of the DescribeTable operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableResponse describeTable(Consumer<DescribeTableRequest.Builder> describeTableRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException,
            InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return describeTable(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other
     * details. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html">code
     * sample</a> for details.
     * </p>
     *
     * @param listBatchLoadTasksRequest
     * @return Result of the ListBatchLoadTasks operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListBatchLoadTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchLoadTasksResponse listBatchLoadTasks(ListBatchLoadTasksRequest listBatchLoadTasksRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other
     * details. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchLoadTasksRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchLoadTasksRequest#builder()}
     * </p>
     *
     * @param listBatchLoadTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchLoadTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListBatchLoadTasks operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListBatchLoadTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchLoadTasksResponse listBatchLoadTasks(Consumer<ListBatchLoadTasksRequest.Builder> listBatchLoadTasksRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return listBatchLoadTasks(ListBatchLoadTasksRequest.builder().applyMutation(listBatchLoadTasksRequest).build());
    }

    /**
     * <p>
     * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other
     * details. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchLoadTasks(software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client.listBatchLoadTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client
     *             .listBatchLoadTasksPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client.listBatchLoadTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchLoadTasks(software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBatchLoadTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListBatchLoadTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchLoadTasksIterable listBatchLoadTasksPaginator(ListBatchLoadTasksRequest listBatchLoadTasksRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other
     * details. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchLoadTasks(software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client.listBatchLoadTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client
     *             .listBatchLoadTasksPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListBatchLoadTasksIterable responses = client.listBatchLoadTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchLoadTasks(software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchLoadTasksRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchLoadTasksRequest#builder()}
     * </p>
     *
     * @param listBatchLoadTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchLoadTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListBatchLoadTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchLoadTasksIterable listBatchLoadTasksPaginator(
            Consumer<ListBatchLoadTasksRequest.Builder> listBatchLoadTasksRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException,
            SdkClientException, TimestreamWriteException {
        return listBatchLoadTasksPaginator(ListBatchLoadTasksRequest.builder().applyMutation(listBatchLoadTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of your Timestream databases. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a>
     * for details.
     * </p>
     *
     * @param listDatabasesRequest
     * @return Result of the ListDatabases operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException,
            SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your Timestream databases. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatabasesRequest.Builder} to create a request.
     * @return Result of the ListDatabases operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatabasesResponse listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return listDatabases(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of your Timestream databases. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client
     *             .listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your Timestream databases. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See
     * <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client
     *             .listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatabasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return listDatabasesPaginator(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Provides a list of tables, along with the name, status, and retention properties of each table. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a>
     * for details.
     * </p>
     *
     * @param listTablesRequest
     * @return Result of the ListTables operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of tables, along with the name, status, and retention properties of each table. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return Result of the ListTables operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * Provides a list of tables, along with the name, status, and retention properties of each table. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of tables, along with the name, status, and retention properties of each table. See <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a>
     * for details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a Timestream resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a Timestream resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * </p>
     *
     * @param resumeBatchLoadTaskRequest
     * @return Result of the ResumeBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ResumeBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ResumeBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeBatchLoadTaskResponse resumeBatchLoadTask(ResumeBatchLoadTaskRequest resumeBatchLoadTaskRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeBatchLoadTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ResumeBatchLoadTaskRequest#builder()}
     * </p>
     *
     * @param resumeBatchLoadTaskRequest
     *        A {@link Consumer} that will call methods on {@link ResumeBatchLoadTaskRequest.Builder} to create a
     *        request.
     * @return Result of the ResumeBatchLoadTask operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.ResumeBatchLoadTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ResumeBatchLoadTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeBatchLoadTaskResponse resumeBatchLoadTask(
            Consumer<ResumeBatchLoadTaskRequest.Builder> resumeBatchLoadTaskRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        return resumeBatchLoadTask(ResumeBatchLoadTaskRequest.builder().applyMutation(resumeBatchLoadTaskRequest).build());
    }

    /**
     * <p>
     * Associates a set of tags with a Timestream resource. You can then activate these user-defined tags so that they
     * appear on the Billing and Cost Management console for cost allocation tracking.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of tags with a Timestream resource. You can then activate these user-defined tags so that they
     * appear on the Billing and Cost Management console for cost allocation tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the association of tags from a Timestream resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of tags from a Timestream resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the KMS key for an existing database. While updating the database, you must specify the database name
     * and the identifier of the new KMS key to be used (<code>KmsKeyId</code>). If there are any concurrent
     * <code>UpdateDatabase</code> requests, first writer wins.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html">code
     * sample</a> for details.
     * </p>
     *
     * @param updateDatabaseRequest
     * @return Result of the UpdateDatabase operation returned by the service.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UpdateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException,
            InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the KMS key for an existing database. While updating the database, you must specify the database name
     * and the identifier of the new KMS key to be used (<code>KmsKeyId</code>). If there are any concurrent
     * <code>UpdateDatabase</code> requests, first writer wins.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatabaseRequest#builder()}
     * </p>
     *
     * @param updateDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatabaseRequest.Builder} to create a request.
     * @return Result of the UpdateDatabase operation returned by the service.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ServiceQuotaExceededException
     *         The instance quota of resource exceeded for this account.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UpdateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatabaseResponse updateDatabase(Consumer<UpdateDatabaseRequest.Builder> updateDatabaseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return updateDatabase(UpdateDatabaseRequest.builder().applyMutation(updateDatabaseRequest).build());
    }

    /**
     * <p>
     * Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the
     * change in retention duration takes effect immediately. For example, if the retention period of the memory store
     * was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours
     * of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not
     * retrieve data from the magnetic store to populate the memory store.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html">code
     * sample</a> for details.
     * </p>
     *
     * @param updateTableRequest
     * @return Result of the UpdateTable operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UpdateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException,
            AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the
     * change in retention duration takes effect immediately. For example, if the retention period of the memory store
     * was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours
     * of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not
     * retrieve data from the magnetic store to populate the memory store.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html">code
     * sample</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTableRequest#builder()}
     * </p>
     *
     * @param updateTableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTableRequest.Builder} to create a request.
     * @return Result of the UpdateTable operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.UpdateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTableResponse updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return updateTable(UpdateTableRequest.builder().applyMutation(updateTableRequest).build());
    }

    /**
     * <p>
     * Enables you to write your time-series data into Timestream. You can specify a single data point or a batch of
     * data points to be inserted into the system. Timestream offers you a flexible schema that auto detects the column
     * names and data types for your Timestream tables based on the dimension names and data types of the data points
     * you specify when invoking writes into the database.
     * </p>
     * <p>
     * Timestream supports eventual consistency read semantics. This means that when you query data immediately after
     * writing a batch of data into Timestream, the query results might not reflect the results of a recently completed
     * write operation. The results may also include some stale data. If you repeat the query request after a short
     * time, the results should return the latest data. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html">code
     * sample</a> for details.
     * </p>
     * <p>
     * <b>Upserts</b>
     * </p>
     * <p>
     * You can use the <code>Version</code> parameter in a <code>WriteRecords</code> request to update data points.
     * Timestream tracks a version number with each record. <code>Version</code> defaults to <code>1</code> when it's
     * not specified for the record in the request. Timestream updates an existing record’s measure value along with its
     * <code>Version</code> when it receives a write request with a higher <code>Version</code> number for that record.
     * When it receives an update request where the measure value is the same as that of the existing record, Timestream
     * still updates <code>Version</code>, if it is greater than the existing value of <code>Version</code>. You can
     * update a data point as many times as desired, as long as the value of <code>Version</code> continuously
     * increases.
     * </p>
     * <p>
     * For example, suppose you write a new record without indicating <code>Version</code> in the request. Timestream
     * stores this record, and set <code>Version</code> to <code>1</code>. Now, suppose you try to update this record
     * with a <code>WriteRecords</code> request of the same record with a different measure value but, like before, do
     * not provide <code>Version</code>. In this case, Timestream will reject this update with a
     * <code>RejectedRecordsException</code> since the updated record’s version is not greater than the existing value
     * of Version.
     * </p>
     * <p>
     * However, if you were to resend the update request with <code>Version</code> set to <code>2</code>, Timestream
     * would then succeed in updating the record’s value, and the <code>Version</code> would be set to <code>2</code>.
     * Next, suppose you sent a <code>WriteRecords</code> request with this same record and an identical measure value,
     * but with <code>Version</code> set to <code>3</code>. In this case, Timestream would only update
     * <code>Version</code> to <code>3</code>. Any further updates would need to send a version number greater than
     * <code>3</code>, or the update requests would receive a <code>RejectedRecordsException</code>.
     * </p>
     *
     * @param writeRecordsRequest
     * @return Result of the WriteRecords operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws RejectedRecordsException
     *         WriteRecords would throw this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Records with duplicate data where there are multiple records with the same dimensions, timestamps, and
     *         measure names but:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Measure values are different
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Version is not present in the request <i>or</i> the value of version in the new record is equal to or
     *         lower than the existing value
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In this case, if Timestream rejects data, the <code>ExistingVersion</code> field in the
     *         <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you
     *         can resend the request with a version for the record set to a value greater than the
     *         <code>ExistingVersion</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records with timestamps that lie outside the retention duration of the memory store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records with dimensions or measures that exceed the Timestream defined limits.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Quotas</a> in the
     *         Amazon Timestream Developer Guide.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.WriteRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords" target="_top">AWS
     *      API Documentation</a>
     */
    default WriteRecordsResponse writeRecords(WriteRecordsRequest writeRecordsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RejectedRecordsException,
            InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to write your time-series data into Timestream. You can specify a single data point or a batch of
     * data points to be inserted into the system. Timestream offers you a flexible schema that auto detects the column
     * names and data types for your Timestream tables based on the dimension names and data types of the data points
     * you specify when invoking writes into the database.
     * </p>
     * <p>
     * Timestream supports eventual consistency read semantics. This means that when you query data immediately after
     * writing a batch of data into Timestream, the query results might not reflect the results of a recently completed
     * write operation. The results may also include some stale data. If you repeat the query request after a short
     * time, the results should return the latest data. <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html">code
     * sample</a> for details.
     * </p>
     * <p>
     * <b>Upserts</b>
     * </p>
     * <p>
     * You can use the <code>Version</code> parameter in a <code>WriteRecords</code> request to update data points.
     * Timestream tracks a version number with each record. <code>Version</code> defaults to <code>1</code> when it's
     * not specified for the record in the request. Timestream updates an existing record’s measure value along with its
     * <code>Version</code> when it receives a write request with a higher <code>Version</code> number for that record.
     * When it receives an update request where the measure value is the same as that of the existing record, Timestream
     * still updates <code>Version</code>, if it is greater than the existing value of <code>Version</code>. You can
     * update a data point as many times as desired, as long as the value of <code>Version</code> continuously
     * increases.
     * </p>
     * <p>
     * For example, suppose you write a new record without indicating <code>Version</code> in the request. Timestream
     * stores this record, and set <code>Version</code> to <code>1</code>. Now, suppose you try to update this record
     * with a <code>WriteRecords</code> request of the same record with a different measure value but, like before, do
     * not provide <code>Version</code>. In this case, Timestream will reject this update with a
     * <code>RejectedRecordsException</code> since the updated record’s version is not greater than the existing value
     * of Version.
     * </p>
     * <p>
     * However, if you were to resend the update request with <code>Version</code> set to <code>2</code>, Timestream
     * would then succeed in updating the record’s value, and the <code>Version</code> would be set to <code>2</code>.
     * Next, suppose you sent a <code>WriteRecords</code> request with this same record and an identical measure value,
     * but with <code>Version</code> set to <code>3</code>. In this case, Timestream would only update
     * <code>Version</code> to <code>3</code>. Any further updates would need to send a version number greater than
     * <code>3</code>, or the update requests would receive a <code>RejectedRecordsException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link WriteRecordsRequest.Builder} avoiding the need to
     * create one manually via {@link WriteRecordsRequest#builder()}
     * </p>
     *
     * @param writeRecordsRequest
     *        A {@link Consumer} that will call methods on {@link WriteRecordsRequest.Builder} to create a request.
     * @return Result of the WriteRecords operation returned by the service.
     * @throws InternalServerException
     *         Timestream was unable to fully process this request because of an internal server error.
     * @throws ThrottlingException
     *         Too many requests were made by a user and they exceeded the service quotas. The request was throttled.
     * @throws ValidationException
     *         An invalid or malformed request.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws AccessDeniedException
     *         You are not authorized to perform this action.
     * @throws RejectedRecordsException
     *         WriteRecords would throw this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Records with duplicate data where there are multiple records with the same dimensions, timestamps, and
     *         measure names but:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Measure values are different
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Version is not present in the request <i>or</i> the value of version in the new record is equal to or
     *         lower than the existing value
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In this case, if Timestream rejects data, the <code>ExistingVersion</code> field in the
     *         <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you
     *         can resend the request with a version for the record set to a value greater than the
     *         <code>ExistingVersion</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records with timestamps that lie outside the retention duration of the memory store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records with dimensions or measures that exceed the Timestream defined limits.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Quotas</a> in the
     *         Amazon Timestream Developer Guide.
     * @throws InvalidEndpointException
     *         The requested endpoint was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamWriteException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamWriteClient.WriteRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords" target="_top">AWS
     *      API Documentation</a>
     */
    default WriteRecordsResponse writeRecords(Consumer<WriteRecordsRequest.Builder> writeRecordsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RejectedRecordsException, InvalidEndpointException, AwsServiceException, SdkClientException,
            TimestreamWriteException {
        return writeRecords(WriteRecordsRequest.builder().applyMutation(writeRecordsRequest).build());
    }

    /**
     * Create a {@link TimestreamWriteClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TimestreamWriteClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TimestreamWriteClient}.
     */
    static TimestreamWriteClientBuilder builder() {
        return new DefaultTimestreamWriteClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TimestreamWriteServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
