/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Records that were not successfully inserted into Timestream due to data validation issues that must be resolved prior
 * to reinserting time series data into the system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectedRecord implements SdkPojo, Serializable, ToCopyableBuilder<RejectedRecord.Builder, RejectedRecord> {
    private static final SdkField<Integer> RECORD_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecordIndex").getter(getter(RejectedRecord::recordIndex)).setter(setter(Builder::recordIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIndex").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(RejectedRecord::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<Long> EXISTING_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ExistingVersion").getter(getter(RejectedRecord::existingVersion))
            .setter(setter(Builder::existingVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_INDEX_FIELD,
            REASON_FIELD, EXISTING_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer recordIndex;

    private final String reason;

    private final Long existingVersion;

    private RejectedRecord(BuilderImpl builder) {
        this.recordIndex = builder.recordIndex;
        this.reason = builder.reason;
        this.existingVersion = builder.existingVersion;
    }

    /**
     * <p>
     * The index of the record in the input request for WriteRecords. Indexes begin with 0.
     * </p>
     * 
     * @return The index of the record in the input request for WriteRecords. Indexes begin with 0.
     */
    public final Integer recordIndex() {
        return recordIndex;
    }

    /**
     * <p>
     * The reason why a record was not successfully inserted into Timestream. Possible causes of failure include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure
     * names but different measure values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Records with timestamps that lie outside the retention duration of the memory store
     * </p>
     * <note>
     * <p>
     * When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you
     * immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code> exception, wait
     * until the duration of the new window to ingest new data. For further information, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration"> Best
     * Practices for Configuring Timestream</a> and <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of how storage
     * works in Timestream</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Records with dimensions or measures that exceed the Timestream defined limits.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a> in the
     * Timestream Developer Guide.
     * </p>
     * 
     * @return The reason why a record was not successfully inserted into Timestream. Possible causes of failure
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Records with duplicate data where there are multiple records with the same dimensions, timestamps, and
     *         measure names but different measure values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records with timestamps that lie outside the retention duration of the memory store
     *         </p>
     *         <note>
     *         <p>
     *         When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you
     *         immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code> exception,
     *         wait until the duration of the new window to ingest new data. For further information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration">
     *         Best Practices for Configuring Timestream</a> and <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of how
     *         storage works in Timestream</a>.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Records with dimensions or measures that exceed the Timestream defined limits.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a>
     *         in the Timestream Developer Guide.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The existing version of the record. This value is populated in scenarios where an identical record exists with a
     * higher version than the version in the write request.
     * </p>
     * 
     * @return The existing version of the record. This value is populated in scenarios where an identical record exists
     *         with a higher version than the version in the write request.
     */
    public final Long existingVersion() {
        return existingVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordIndex());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(existingVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectedRecord)) {
            return false;
        }
        RejectedRecord other = (RejectedRecord) obj;
        return Objects.equals(recordIndex(), other.recordIndex()) && Objects.equals(reason(), other.reason())
                && Objects.equals(existingVersion(), other.existingVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectedRecord").add("RecordIndex", recordIndex()).add("Reason", reason())
                .add("ExistingVersion", existingVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordIndex":
            return Optional.ofNullable(clazz.cast(recordIndex()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "ExistingVersion":
            return Optional.ofNullable(clazz.cast(existingVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectedRecord, T> g) {
        return obj -> g.apply((RejectedRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectedRecord> {
        /**
         * <p>
         * The index of the record in the input request for WriteRecords. Indexes begin with 0.
         * </p>
         * 
         * @param recordIndex
         *        The index of the record in the input request for WriteRecords. Indexes begin with 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIndex(Integer recordIndex);

        /**
         * <p>
         * The reason why a record was not successfully inserted into Timestream. Possible causes of failure include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Records with duplicate data where there are multiple records with the same dimensions, timestamps, and
         * measure names but different measure values.
         * </p>
         * </li>
         * <li>
         * <p>
         * Records with timestamps that lie outside the retention duration of the memory store
         * </p>
         * <note>
         * <p>
         * When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you
         * immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code> exception, wait
         * until the duration of the new window to ingest new data. For further information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration"> Best
         * Practices for Configuring Timestream</a> and <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of how
         * storage works in Timestream</a>.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * Records with dimensions or measures that exceed the Timestream defined limits.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a> in
         * the Timestream Developer Guide.
         * </p>
         * 
         * @param reason
         *        The reason why a record was not successfully inserted into Timestream. Possible causes of failure
         *        include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Records with duplicate data where there are multiple records with the same dimensions, timestamps, and
         *        measure names but different measure values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Records with timestamps that lie outside the retention duration of the memory store
         *        </p>
         *        <note>
         *        <p>
         *        When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you
         *        immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code>
         *        exception, wait until the duration of the new window to ingest new data. For further information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration"> Best
         *        Practices for Configuring Timestream</a> and <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of
         *        how storage works in Timestream</a>.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        Records with dimensions or measures that exceed the Timestream defined limits.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access
         *        Management</a> in the Timestream Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The existing version of the record. This value is populated in scenarios where an identical record exists
         * with a higher version than the version in the write request.
         * </p>
         * 
         * @param existingVersion
         *        The existing version of the record. This value is populated in scenarios where an identical record
         *        exists with a higher version than the version in the write request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingVersion(Long existingVersion);
    }

    static final class BuilderImpl implements Builder {
        private Integer recordIndex;

        private String reason;

        private Long existingVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedRecord model) {
            recordIndex(model.recordIndex);
            reason(model.reason);
            existingVersion(model.existingVersion);
        }

        public final Integer getRecordIndex() {
            return recordIndex;
        }

        @Override
        public final Builder recordIndex(Integer recordIndex) {
            this.recordIndex = recordIndex;
            return this;
        }

        public final void setRecordIndex(Integer recordIndex) {
            this.recordIndex = recordIndex;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Long getExistingVersion() {
            return existingVersion;
        }

        @Override
        public final Builder existingVersion(Long existingVersion) {
            this.existingVersion = existingVersion;
            return this;
        }

        public final void setExistingVersion(Long existingVersion) {
            this.existingVersion = existingVersion;
        }

        @Override
        public RejectedRecord build() {
            return new RejectedRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
