/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
class TimestreamWriteEndpointDiscoveryCacheLoader implements EndpointDiscoveryCacheLoader {
    private final TimestreamWriteClient client;

    private TimestreamWriteEndpointDiscoveryCacheLoader(TimestreamWriteClient client) {
        this.client = client;
    }

    public static TimestreamWriteEndpointDiscoveryCacheLoader create(TimestreamWriteClient client) {
        return new TimestreamWriteEndpointDiscoveryCacheLoader(client);
    }

    @Override
    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return CompletableFuture.supplyAsync(() -> {
            DescribeEndpointsResponse response = client
                    .describeEndpoints(software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest.builder()
                            .build());
            List<Endpoint> endpoints = response.endpoints();
            Validate.notEmpty(endpoints, "Endpoints returned by service for endpoint discovery must not be empty.");
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder()
                    .endpoint(toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint()))
                    .expirationTime(Instant.now().plus(endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}
