/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TextType {
    HANDWRITING("HANDWRITING"),
    PRINTED("PRINTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TextType> VALUE_MAP;
    private final String value;

    private TextType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextType> knownValues() {
        EnumSet<TextType> knownValues = EnumSet.allOf(TextType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TextType.class, TextType::toString);
    }
}

