/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.textract.model.AutoUpdate;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.TagMapCopier;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAdapterResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, GetAdapterResponse> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(GetAdapterResponse.getter(GetAdapterResponse::adapterId)).setter(GetAdapterResponse.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> ADAPTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterName").getter(GetAdapterResponse.getter(GetAdapterResponse::adapterName)).setter(GetAdapterResponse.setter(Builder::adapterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetAdapterResponse.getter(GetAdapterResponse::creationTime)).setter(GetAdapterResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetAdapterResponse.getter(GetAdapterResponse::description)).setter(GetAdapterResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(GetAdapterResponse.getter(GetAdapterResponse::featureTypesAsStrings)).setter(GetAdapterResponse.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoUpdate").getter(GetAdapterResponse.getter(GetAdapterResponse::autoUpdateAsString)).setter(GetAdapterResponse.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetAdapterResponse.getter(GetAdapterResponse::tags)).setter(GetAdapterResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, ADAPTER_NAME_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, FEATURE_TYPES_FIELD, AUTO_UPDATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdapterId", ADAPTER_ID_FIELD);
            this.put("AdapterName", ADAPTER_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("FeatureTypes", FEATURE_TYPES_FIELD);
            this.put("AutoUpdate", AUTO_UPDATE_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String adapterId;
    private final String adapterName;
    private final Instant creationTime;
    private final String description;
    private final List<String> featureTypes;
    private final String autoUpdate;
    private final Map<String, String> tags;

    private GetAdapterResponse(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.adapterName = builder.adapterName;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.featureTypes = builder.featureTypes;
        this.autoUpdate = builder.autoUpdate;
        this.tags = builder.tags;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String adapterName() {
        return this.adapterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final AutoUpdate autoUpdate() {
        return AutoUpdate.fromValue(this.autoUpdate);
    }

    public final String autoUpdateAsString() {
        return this.autoUpdate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdapterResponse)) {
            return false;
        }
        GetAdapterResponse other = (GetAdapterResponse)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.adapterName(), other.adapterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.autoUpdateAsString(), other.autoUpdateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetAdapterResponse").add("AdapterId", (Object)this.adapterId()).add("AdapterName", (Object)this.adapterName()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("AutoUpdate", (Object)this.autoUpdateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "AdapterName": {
                return Optional.ofNullable(clazz.cast(this.adapterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "AutoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAdapterResponse, T> g) {
        return obj -> g.apply((GetAdapterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private String adapterId;
        private String adapterName;
        private Instant creationTime;
        private String description;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String autoUpdate;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdapterResponse model) {
            super(model);
            this.adapterId(model.adapterId);
            this.adapterName(model.adapterName);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.featureTypesWithStrings(model.featureTypes);
            this.autoUpdate(model.autoUpdate);
            this.tags(model.tags);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterName() {
            return this.adapterName;
        }

        public final void setAdapterName(String adapterName) {
            this.adapterName = adapterName;
        }

        @Override
        public final Builder adapterName(String adapterName) {
            this.adapterName = adapterName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(AutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAdapterResponse build() {
            return new GetAdapterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAdapterResponse> {
        public Builder adapterId(String var1);

        public Builder adapterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder autoUpdate(String var1);

        public Builder autoUpdate(AutoUpdate var1);

        public Builder tags(Map<String, String> var1);
    }
}

