/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig;
import software.amazon.awssdk.services.textract.model.OutputConfig;
import software.amazon.awssdk.services.textract.model.TagMapCopier;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAdapterVersionRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, CreateAdapterVersionRequest> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::adapterId)).setter(CreateAdapterVersionRequest.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::clientRequestToken)).setter(CreateAdapterVersionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AdapterVersionDatasetConfig> DATASET_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetConfig").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::datasetConfig)).setter(CreateAdapterVersionRequest.setter(Builder::datasetConfig)).constructor(AdapterVersionDatasetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::kmsKeyId)).setter(CreateAdapterVersionRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::outputConfig)).setter(CreateAdapterVersionRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAdapterVersionRequest.getter(CreateAdapterVersionRequest::tags)).setter(CreateAdapterVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DATASET_CONFIG_FIELD, KMS_KEY_ID_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD));
    private final String adapterId;
    private final String clientRequestToken;
    private final AdapterVersionDatasetConfig datasetConfig;
    private final String kmsKeyId;
    private final OutputConfig outputConfig;
    private final Map<String, String> tags;

    private CreateAdapterVersionRequest(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.clientRequestToken = builder.clientRequestToken;
        this.datasetConfig = builder.datasetConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final AdapterVersionDatasetConfig datasetConfig() {
        return this.datasetConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdapterVersionRequest)) {
            return false;
        }
        CreateAdapterVersionRequest other = (CreateAdapterVersionRequest)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.datasetConfig(), other.datasetConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAdapterVersionRequest").add("AdapterId", (Object)this.adapterId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("DatasetConfig", (Object)this.datasetConfig()).add("KMSKeyId", (Object)this.kmsKeyId()).add("OutputConfig", (Object)this.outputConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "DatasetConfig": {
                return Optional.ofNullable(clazz.cast(this.datasetConfig()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAdapterVersionRequest, T> g) {
        return obj -> g.apply((CreateAdapterVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private String adapterId;
        private String clientRequestToken;
        private AdapterVersionDatasetConfig datasetConfig;
        private String kmsKeyId;
        private OutputConfig outputConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdapterVersionRequest model) {
            super(model);
            this.adapterId(model.adapterId);
            this.clientRequestToken(model.clientRequestToken);
            this.datasetConfig(model.datasetConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.outputConfig(model.outputConfig);
            this.tags(model.tags);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final AdapterVersionDatasetConfig.Builder getDatasetConfig() {
            return this.datasetConfig != null ? this.datasetConfig.toBuilder() : null;
        }

        public final void setDatasetConfig(AdapterVersionDatasetConfig.BuilderImpl datasetConfig) {
            this.datasetConfig = datasetConfig != null ? datasetConfig.build() : null;
        }

        @Override
        public final Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig) {
            this.datasetConfig = datasetConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdapterVersionRequest build() {
            return new CreateAdapterVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAdapterVersionRequest> {
        public Builder adapterId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder datasetConfig(AdapterVersionDatasetConfig var1);

        default public Builder datasetConfig(Consumer<AdapterVersionDatasetConfig.Builder> datasetConfig) {
            return this.datasetConfig((AdapterVersionDatasetConfig)((AdapterVersionDatasetConfig.Builder)AdapterVersionDatasetConfig.builder().applyMutation(datasetConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

