/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that lists each document processed in an AnalyzeID operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityDocument.Builder, IdentityDocument> {
    private static final SdkField<Integer> DOCUMENT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DocumentIndex").getter(getter(IdentityDocument::documentIndex)).setter(setter(Builder::documentIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIndex").build()).build();

    private static final SdkField<List<IdentityDocumentField>> IDENTITY_DOCUMENT_FIELDS_FIELD = SdkField
            .<List<IdentityDocumentField>> builder(MarshallingType.LIST)
            .memberName("IdentityDocumentFields")
            .getter(getter(IdentityDocument::identityDocumentFields))
            .setter(setter(Builder::identityDocumentFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityDocumentFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityDocumentField> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityDocumentField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField
            .<List<Block>> builder(MarshallingType.LIST)
            .memberName("Blocks")
            .getter(getter(IdentityDocument::blocks))
            .setter(setter(Builder::blocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Block> builder(MarshallingType.SDK_POJO)
                                            .constructor(Block::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_INDEX_FIELD,
            IDENTITY_DOCUMENT_FIELDS_FIELD, BLOCKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer documentIndex;

    private final List<IdentityDocumentField> identityDocumentFields;

    private final List<Block> blocks;

    private IdentityDocument(BuilderImpl builder) {
        this.documentIndex = builder.documentIndex;
        this.identityDocumentFields = builder.identityDocumentFields;
        this.blocks = builder.blocks;
    }

    /**
     * <p>
     * Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the second 2
     * and so on.
     * </p>
     * 
     * @return Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the
     *         second 2 and so on.
     */
    public final Integer documentIndex() {
        return documentIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityDocumentFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityDocumentFields() {
        return identityDocumentFields != null && !(identityDocumentFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The structure used to record information extracted from identity documents. Contains both normalized field and
     * value of the extracted text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityDocumentFields} method.
     * </p>
     * 
     * @return The structure used to record information extracted from identity documents. Contains both normalized
     *         field and value of the extracted text.
     */
    public final List<IdentityDocumentField> identityDocumentFields() {
        return identityDocumentFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlocks() {
        return blocks != null && !(blocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Individual word recognition, as returned by document detection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlocks} method.
     * </p>
     * 
     * @return Individual word recognition, as returned by document detection.
     */
    public final List<Block> blocks() {
        return blocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityDocumentFields() ? identityDocumentFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocks() ? blocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDocument)) {
            return false;
        }
        IdentityDocument other = (IdentityDocument) obj;
        return Objects.equals(documentIndex(), other.documentIndex())
                && hasIdentityDocumentFields() == other.hasIdentityDocumentFields()
                && Objects.equals(identityDocumentFields(), other.identityDocumentFields()) && hasBlocks() == other.hasBlocks()
                && Objects.equals(blocks(), other.blocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityDocument").add("DocumentIndex", documentIndex())
                .add("IdentityDocumentFields", hasIdentityDocumentFields() ? identityDocumentFields() : null)
                .add("Blocks", hasBlocks() ? blocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentIndex":
            return Optional.ofNullable(clazz.cast(documentIndex()));
        case "IdentityDocumentFields":
            return Optional.ofNullable(clazz.cast(identityDocumentFields()));
        case "Blocks":
            return Optional.ofNullable(clazz.cast(blocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityDocument, T> g) {
        return obj -> g.apply((IdentityDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityDocument> {
        /**
         * <p>
         * Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the second
         * 2 and so on.
         * </p>
         * 
         * @param documentIndex
         *        Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the
         *        second 2 and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIndex(Integer documentIndex);

        /**
         * <p>
         * The structure used to record information extracted from identity documents. Contains both normalized field
         * and value of the extracted text.
         * </p>
         * 
         * @param identityDocumentFields
         *        The structure used to record information extracted from identity documents. Contains both normalized
         *        field and value of the extracted text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityDocumentFields(Collection<IdentityDocumentField> identityDocumentFields);

        /**
         * <p>
         * The structure used to record information extracted from identity documents. Contains both normalized field
         * and value of the extracted text.
         * </p>
         * 
         * @param identityDocumentFields
         *        The structure used to record information extracted from identity documents. Contains both normalized
         *        field and value of the extracted text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityDocumentFields(IdentityDocumentField... identityDocumentFields);

        /**
         * <p>
         * The structure used to record information extracted from identity documents. Contains both normalized field
         * and value of the extracted text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.IdentityDocumentField.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.textract.model.IdentityDocumentField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.IdentityDocumentField.Builder#build()} is called
         * immediately and its result is passed to {@link #identityDocumentFields(List<IdentityDocumentField>)}.
         * 
         * @param identityDocumentFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.IdentityDocumentField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityDocumentFields(java.util.Collection<IdentityDocumentField>)
         */
        Builder identityDocumentFields(Consumer<IdentityDocumentField.Builder>... identityDocumentFields);

        /**
         * <p>
         * Individual word recognition, as returned by document detection.
         * </p>
         * 
         * @param blocks
         *        Individual word recognition, as returned by document detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Collection<Block> blocks);

        /**
         * <p>
         * Individual word recognition, as returned by document detection.
         * </p>
         * 
         * @param blocks
         *        Individual word recognition, as returned by document detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Block... blocks);

        /**
         * <p>
         * Individual word recognition, as returned by document detection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Block.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.textract.model.Block#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Block.Builder#build()} is called immediately and its
         * result is passed to {@link #blocks(List<Block>)}.
         * 
         * @param blocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Block.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocks(java.util.Collection<Block>)
         */
        Builder blocks(Consumer<Block.Builder>... blocks);
    }

    static final class BuilderImpl implements Builder {
        private Integer documentIndex;

        private List<IdentityDocumentField> identityDocumentFields = DefaultSdkAutoConstructList.getInstance();

        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDocument model) {
            documentIndex(model.documentIndex);
            identityDocumentFields(model.identityDocumentFields);
            blocks(model.blocks);
        }

        public final Integer getDocumentIndex() {
            return documentIndex;
        }

        public final void setDocumentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
        }

        @Override
        public final Builder documentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
            return this;
        }

        public final List<IdentityDocumentField.Builder> getIdentityDocumentFields() {
            List<IdentityDocumentField.Builder> result = IdentityDocumentFieldListCopier
                    .copyToBuilder(this.identityDocumentFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityDocumentFields(Collection<IdentityDocumentField.BuilderImpl> identityDocumentFields) {
            this.identityDocumentFields = IdentityDocumentFieldListCopier.copyFromBuilder(identityDocumentFields);
        }

        @Override
        public final Builder identityDocumentFields(Collection<IdentityDocumentField> identityDocumentFields) {
            this.identityDocumentFields = IdentityDocumentFieldListCopier.copy(identityDocumentFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityDocumentFields(IdentityDocumentField... identityDocumentFields) {
            identityDocumentFields(Arrays.asList(identityDocumentFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityDocumentFields(Consumer<IdentityDocumentField.Builder>... identityDocumentFields) {
            identityDocumentFields(Stream.of(identityDocumentFields)
                    .map(c -> IdentityDocumentField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = BlockListCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block... blocks) {
            blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder>... blocks) {
            blocks(Stream.of(blocks).map(c -> Block.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IdentityDocument build() {
            return new IdentityDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
