/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>WorkflowExecutionCancelRequested</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionCancelRequestedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<WorkflowExecutionCancelRequestedEventAttributes.Builder, WorkflowExecutionCancelRequestedEventAttributes> {
    private static final SdkField<WorkflowExecution> EXTERNAL_WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO)
            .getter(getter(WorkflowExecutionCancelRequestedEventAttributes::externalWorkflowExecution))
            .setter(setter(Builder::externalWorkflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalWorkflowExecution").build())
            .build();

    private static final SdkField<Long> EXTERNAL_INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(WorkflowExecutionCancelRequestedEventAttributes::externalInitiatedEventId))
            .setter(setter(Builder::externalInitiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalInitiatedEventId").build())
            .build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkflowExecutionCancelRequestedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXTERNAL_WORKFLOW_EXECUTION_FIELD, EXTERNAL_INITIATED_EVENT_ID_FIELD, CAUSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkflowExecution externalWorkflowExecution;

    private final Long externalInitiatedEventId;

    private final String causeValue;

    private WorkflowExecutionCancelRequestedEventAttributes(BuilderImpl builder) {
        this.externalWorkflowExecution = builder.externalWorkflowExecution;
        this.externalInitiatedEventId = builder.externalInitiatedEventId;
        this.causeValue = builder.causeValue;
    }

    /**
     * <p>
     * The external workflow execution for which the cancellation was requested.
     * </p>
     * 
     * @return The external workflow execution for which the cancellation was requested.
     */
    public WorkflowExecution externalWorkflowExecution() {
        return externalWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
     * with this ID can be found in the history of the source workflow execution. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source
     *         event with this ID can be found in the history of the source workflow execution. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long externalInitiatedEventId() {
        return externalInitiatedEventId;
    }

    /**
     * <p>
     * If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies
     * the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set
     * to cancel child executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link WorkflowExecutionCancelRequestedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return If set, indicates that the request to cancel the workflow execution was automatically generated, and
     *         specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
     *         child policy is set to cancel child executions.
     * @see WorkflowExecutionCancelRequestedCause
     */
    public WorkflowExecutionCancelRequestedCause cause() {
        return WorkflowExecutionCancelRequestedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies
     * the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set
     * to cancel child executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link WorkflowExecutionCancelRequestedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return If set, indicates that the request to cancel the workflow execution was automatically generated, and
     *         specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
     *         child policy is set to cancel child executions.
     * @see WorkflowExecutionCancelRequestedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalWorkflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(externalInitiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionCancelRequestedEventAttributes)) {
            return false;
        }
        WorkflowExecutionCancelRequestedEventAttributes other = (WorkflowExecutionCancelRequestedEventAttributes) obj;
        return Objects.equals(externalWorkflowExecution(), other.externalWorkflowExecution())
                && Objects.equals(externalInitiatedEventId(), other.externalInitiatedEventId())
                && Objects.equals(causeAsString(), other.causeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorkflowExecutionCancelRequestedEventAttributes")
                .add("ExternalWorkflowExecution", externalWorkflowExecution())
                .add("ExternalInitiatedEventId", externalInitiatedEventId()).add("Cause", causeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalWorkflowExecution":
            return Optional.ofNullable(clazz.cast(externalWorkflowExecution()));
        case "externalInitiatedEventId":
            return Optional.ofNullable(clazz.cast(externalInitiatedEventId()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionCancelRequestedEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionCancelRequestedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionCancelRequestedEventAttributes> {
        /**
         * <p>
         * The external workflow execution for which the cancellation was requested.
         * </p>
         * 
         * @param externalWorkflowExecution
         *        The external workflow execution for which the cancellation was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution);

        /**
         * <p>
         * The external workflow execution for which the cancellation was requested.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #externalWorkflowExecution(WorkflowExecution)}.
         * 
         * @param externalWorkflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalWorkflowExecution(WorkflowExecution)
         */
        default Builder externalWorkflowExecution(Consumer<WorkflowExecution.Builder> externalWorkflowExecution) {
            return externalWorkflowExecution(WorkflowExecution.builder().applyMutation(externalWorkflowExecution).build());
        }

        /**
         * <p>
         * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source
         * event with this ID can be found in the history of the source workflow execution. This information can be
         * useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param externalInitiatedEventId
         *        The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The
         *        source event with this ID can be found in the history of the source workflow execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalInitiatedEventId(Long externalInitiatedEventId);

        /**
         * <p>
         * If set, indicates that the request to cancel the workflow execution was automatically generated, and
         * specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child
         * policy is set to cancel child executions.
         * </p>
         * 
         * @param causeValue
         *        If set, indicates that the request to cancel the workflow execution was automatically generated, and
         *        specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
         *        child policy is set to cancel child executions.
         * @see WorkflowExecutionCancelRequestedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionCancelRequestedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * If set, indicates that the request to cancel the workflow execution was automatically generated, and
         * specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child
         * policy is set to cancel child executions.
         * </p>
         * 
         * @param causeValue
         *        If set, indicates that the request to cancel the workflow execution was automatically generated, and
         *        specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
         *        child policy is set to cancel child executions.
         * @see WorkflowExecutionCancelRequestedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionCancelRequestedCause
         */
        Builder cause(WorkflowExecutionCancelRequestedCause causeValue);
    }

    static final class BuilderImpl implements Builder {
        private WorkflowExecution externalWorkflowExecution;

        private Long externalInitiatedEventId;

        private String causeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionCancelRequestedEventAttributes model) {
            externalWorkflowExecution(model.externalWorkflowExecution);
            externalInitiatedEventId(model.externalInitiatedEventId);
            cause(model.causeValue);
        }

        public final WorkflowExecution.Builder getExternalWorkflowExecution() {
            return externalWorkflowExecution != null ? externalWorkflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
            return this;
        }

        public final void setExternalWorkflowExecution(WorkflowExecution.BuilderImpl externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution != null ? externalWorkflowExecution.build() : null;
        }

        public final Long getExternalInitiatedEventId() {
            return externalInitiatedEventId;
        }

        @Override
        public final Builder externalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
            return this;
        }

        public final void setExternalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
        }

        public final String getCauseAsString() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(WorkflowExecutionCancelRequestedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public WorkflowExecutionCancelRequestedEventAttributes build() {
            return new WorkflowExecutionCancelRequestedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
