/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>StartLambdaFunctionFailed</code> event. It isn't set for other event types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLambdaFunctionFailedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<StartLambdaFunctionFailedEventAttributes.Builder, StartLambdaFunctionFailedEventAttributes> {
    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartLambdaFunctionFailedEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartLambdaFunctionFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartLambdaFunctionFailedEventAttributes::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_EVENT_ID_FIELD,
            CAUSE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long scheduledEventId;

    private final String causeValue;

    private final String message;

    private StartLambdaFunctionFailedEventAttributes(BuilderImpl builder) {
        this.scheduledEventId = builder.scheduledEventId;
        this.causeValue = builder.causeValue;
        this.message = builder.message;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to
     *         this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading
     * up to this event.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM role
     * attached to the execution lacked sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
     * <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link StartLambdaFunctionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
     *         leading up to this event.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM
     *         role attached to the execution lacked sufficient permissions. For details and example IAM policies, see
     *         <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a>
     *         in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see StartLambdaFunctionFailedCause
     */
    public StartLambdaFunctionFailedCause cause() {
        return StartLambdaFunctionFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading
     * up to this event.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM role
     * attached to the execution lacked sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
     * <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link StartLambdaFunctionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
     *         leading up to this event.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM
     *         role attached to the execution lacked sufficient permissions. For details and example IAM policies, see
     *         <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a>
     *         in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see StartLambdaFunctionFailedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * A description that can help diagnose the cause of the fault.
     * </p>
     * 
     * @return A description that can help diagnose the cause of the fault.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLambdaFunctionFailedEventAttributes)) {
            return false;
        }
        StartLambdaFunctionFailedEventAttributes other = (StartLambdaFunctionFailedEventAttributes) obj;
        return Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(causeAsString(), other.causeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartLambdaFunctionFailedEventAttributes").add("ScheduledEventId", scheduledEventId())
                .add("Cause", causeAsString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartLambdaFunctionFailedEventAttributes, T> g) {
        return obj -> g.apply((StartLambdaFunctionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartLambdaFunctionFailedEventAttributes> {
        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. To help diagnose issues, use this information to trace back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
         * leading up to this event.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM
         * role attached to the execution lacked sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
         * <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. To help diagnose issues, use this information to trace back the chain of
         *        events leading up to this event.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the
         *        IAM role attached to the execution lacked sufficient permissions. For details and example IAM
         *        policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a>
         *        in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see StartLambdaFunctionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartLambdaFunctionFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
         * leading up to this event.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the IAM
         * role attached to the execution lacked sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a> in the
         * <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. To help diagnose issues, use this information to trace back the chain of
         *        events leading up to this event.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because the
         *        IAM role attached to the execution lacked sufficient permissions. For details and example IAM
         *        policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">Lambda Tasks</a>
         *        in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see StartLambdaFunctionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartLambdaFunctionFailedCause
         */
        Builder cause(StartLambdaFunctionFailedCause causeValue);

        /**
         * <p>
         * A description that can help diagnose the cause of the fault.
         * </p>
         * 
         * @param message
         *        A description that can help diagnose the cause of the fault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private Long scheduledEventId;

        private String causeValue;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLambdaFunctionFailedEventAttributes model) {
            scheduledEventId(model.scheduledEventId);
            cause(model.causeValue);
            message(model.message);
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final String getCauseAsString() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(StartLambdaFunctionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public StartLambdaFunctionFailedEventAttributes build() {
            return new StartLambdaFunctionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
