/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ContinueAsNewWorkflowExecutionFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinueAsNewWorkflowExecutionFailedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder, ContinueAsNewWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContinueAsNewWorkflowExecutionFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(ContinueAsNewWorkflowExecutionFailedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAUSE_FIELD,
            DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String causeValue;

    private final Long decisionTaskCompletedEventId;

    private ContinueAsNewWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.causeValue = builder.causeValue;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ContinueAsNewWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ContinueAsNewWorkflowExecutionFailedCause
     */
    public ContinueAsNewWorkflowExecutionFailedCause cause() {
        return ContinueAsNewWorkflowExecutionFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ContinueAsNewWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ContinueAsNewWorkflowExecutionFailedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be useful
     * for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information
     *         can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueAsNewWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        ContinueAsNewWorkflowExecutionFailedEventAttributes other = (ContinueAsNewWorkflowExecutionFailedEventAttributes) obj;
        return Objects.equals(causeAsString(), other.causeAsString())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContinueAsNewWorkflowExecutionFailedEventAttributes").add("Cause", causeAsString())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinueAsNewWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((ContinueAsNewWorkflowExecutionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinueAsNewWorkflowExecutionFailedEventAttributes> {
        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ContinueAsNewWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinueAsNewWorkflowExecutionFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ContinueAsNewWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinueAsNewWorkflowExecutionFailedCause
         */
        Builder cause(ContinueAsNewWorkflowExecutionFailedCause causeValue);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This information can be
         * useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>ContinueAsNewWorkflowExecution</code> decision that started this execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String causeValue;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueAsNewWorkflowExecutionFailedEventAttributes model) {
            cause(model.causeValue);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getCauseAsString() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(ContinueAsNewWorkflowExecutionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public ContinueAsNewWorkflowExecutionFailedEventAttributes build() {
            return new ContinueAsNewWorkflowExecutionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
