/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.swf.DefaultSwfBaseClientBuilder;
import software.amazon.awssdk.services.swf.DefaultSwfClient;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.SwfClientBuilder;
import software.amazon.awssdk.services.swf.SwfServiceClientConfiguration;
import software.amazon.awssdk.services.swf.endpoints.SwfEndpointProvider;

@SdkInternalApi
final class DefaultSwfClientBuilder
extends DefaultSwfBaseClientBuilder<SwfClientBuilder, SwfClient>
implements SwfClientBuilder {
    DefaultSwfClientBuilder() {
    }

    @Override
    public DefaultSwfClientBuilder endpointProvider(SwfEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SwfClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSwfClientBuilder.validateClientOptions(clientConfiguration);
        SwfServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSwfClient client = new DefaultSwfClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SwfServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SwfServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

