/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings of a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowTypeConfiguration.Builder, WorkflowTypeConfiguration> {
    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskStartToCloseTimeout")
            .getter(getter(WorkflowTypeConfiguration::defaultTaskStartToCloseTimeout))
            .setter(setter(Builder::defaultTaskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultExecutionStartToCloseTimeout")
            .getter(getter(WorkflowTypeConfiguration::defaultExecutionStartToCloseTimeout))
            .setter(setter(Builder::defaultExecutionStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("defaultExecutionStartToCloseTimeout").build()).build();

    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("defaultTaskList").getter(getter(WorkflowTypeConfiguration::defaultTaskList))
            .setter(setter(Builder::defaultTaskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()).build();

    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskPriority").getter(getter(WorkflowTypeConfiguration::defaultTaskPriority))
            .setter(setter(Builder::defaultTaskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build())
            .build();

    private static final SdkField<String> DEFAULT_CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultChildPolicy").getter(getter(WorkflowTypeConfiguration::defaultChildPolicyAsString))
            .setter(setter(Builder::defaultChildPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultChildPolicy").build())
            .build();

    private static final SdkField<String> DEFAULT_LAMBDA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultLambdaRole").getter(getter(WorkflowTypeConfiguration::defaultLambdaRole))
            .setter(setter(Builder::defaultLambdaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLambdaRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_LIST_FIELD,
            DEFAULT_TASK_PRIORITY_FIELD, DEFAULT_CHILD_POLICY_FIELD, DEFAULT_LAMBDA_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultExecutionStartToCloseTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultChildPolicy;

    private final String defaultLambdaRole;

    private WorkflowTypeConfiguration(BuilderImpl builder) {
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    /**
     * <p>
     * The default maximum duration, specified when registering the workflow type, that a decision task for executions
     * of this workflow type might take before returning completion or failure. If the task doesn'tdo close in the
     * specified time then the task is automatically timed out and rescheduled. If the decider eventually reports a
     * completion or failure, it is ignored. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum duration, specified when registering the workflow type, that a decision task for
     *         executions of this workflow type might take before returning completion or failure. If the task doesn'tdo
     *         close in the specified time then the task is automatically timed out and rescheduled. If the decider
     *         eventually reports a completion or failure, it is ignored. This default can be overridden when starting a
     *         workflow execution using the <a>StartWorkflowExecution</a> action or the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * The default maximum duration, specified when registering the workflow type, for executions of this workflow type.
     * This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action
     * or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum duration, specified when registering the workflow type, for executions of this
     *         workflow type. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultExecutionStartToCloseTimeout() {
        return defaultExecutionStartToCloseTimeout;
    }

    /**
     * <p>
     * The default task list, specified when registering the workflow type, for decisions tasks scheduled for workflow
     * executions of this type. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * 
     * @return The default task list, specified when registering the workflow type, for decisions tasks scheduled for
     *         workflow executions of this type. This default can be overridden when starting a workflow execution using
     *         the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     */
    public final TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority, specified when registering the workflow type, for all decision tasks of this workflow
     * type. This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
     * action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The default task priority, specified when registering the workflow type, for all decision tasks of this
     *         workflow type. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public final String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * The default policy to use for the child workflow executions when a workflow execution of this type is terminated,
     * by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This default can
     * be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultChildPolicy} will return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultChildPolicyAsString}.
     * </p>
     * 
     * @return The default policy to use for the child workflow executions when a workflow execution of this type is
     *         terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     *         timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public final ChildPolicy defaultChildPolicy() {
        return ChildPolicy.fromValue(defaultChildPolicy);
    }

    /**
     * <p>
     * The default policy to use for the child workflow executions when a workflow execution of this type is terminated,
     * by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This default can
     * be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultChildPolicy} will return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultChildPolicyAsString}.
     * </p>
     * 
     * @return The default policy to use for the child workflow executions when a workflow execution of this type is
     *         terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     *         timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public final String defaultChildPolicyAsString() {
        return defaultChildPolicy;
    }

    /**
     * <p>
     * The default IAM role attached to this workflow type.
     * </p>
     * <note>
     * <p>
     * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when
     * starting this workflow type, the default Lambda role is attached to the execution. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/
     * amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The default IAM role attached to this workflow type.</p> <note>
     *         <p>
     *         Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM
     *         role when starting this workflow type, the default Lambda role is attached to the execution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https
     *         ://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF
     *         Developer Guide</i>.
     *         </p>
     */
    public final String defaultLambdaRole() {
        return defaultLambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExecutionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(defaultChildPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLambdaRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowTypeConfiguration)) {
            return false;
        }
        WorkflowTypeConfiguration other = (WorkflowTypeConfiguration) obj;
        return Objects.equals(defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout())
                && Objects.equals(defaultExecutionStartToCloseTimeout(), other.defaultExecutionStartToCloseTimeout())
                && Objects.equals(defaultTaskList(), other.defaultTaskList())
                && Objects.equals(defaultTaskPriority(), other.defaultTaskPriority())
                && Objects.equals(defaultChildPolicyAsString(), other.defaultChildPolicyAsString())
                && Objects.equals(defaultLambdaRole(), other.defaultLambdaRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowTypeConfiguration")
                .add("DefaultTaskStartToCloseTimeout", defaultTaskStartToCloseTimeout())
                .add("DefaultExecutionStartToCloseTimeout", defaultExecutionStartToCloseTimeout())
                .add("DefaultTaskList", defaultTaskList()).add("DefaultTaskPriority", defaultTaskPriority())
                .add("DefaultChildPolicy", defaultChildPolicyAsString()).add("DefaultLambdaRole", defaultLambdaRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultTaskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskStartToCloseTimeout()));
        case "defaultExecutionStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultExecutionStartToCloseTimeout()));
        case "defaultTaskList":
            return Optional.ofNullable(clazz.cast(defaultTaskList()));
        case "defaultTaskPriority":
            return Optional.ofNullable(clazz.cast(defaultTaskPriority()));
        case "defaultChildPolicy":
            return Optional.ofNullable(clazz.cast(defaultChildPolicyAsString()));
        case "defaultLambdaRole":
            return Optional.ofNullable(clazz.cast(defaultLambdaRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowTypeConfiguration, T> g) {
        return obj -> g.apply((WorkflowTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowTypeConfiguration> {
        /**
         * <p>
         * The default maximum duration, specified when registering the workflow type, that a decision task for
         * executions of this workflow type might take before returning completion or failure. If the task doesn'tdo
         * close in the specified time then the task is automatically timed out and rescheduled. If the decider
         * eventually reports a completion or failure, it is ignored. This default can be overridden when starting a
         * workflow execution using the <a>StartWorkflowExecution</a> action or the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        The default maximum duration, specified when registering the workflow type, that a decision task for
         *        executions of this workflow type might take before returning completion or failure. If the task
         *        doesn'tdo close in the specified time then the task is automatically timed out and rescheduled. If the
         *        decider eventually reports a completion or failure, it is ignored. This default can be overridden when
         *        starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * The default maximum duration, specified when registering the workflow type, for executions of this workflow
         * type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultExecutionStartToCloseTimeout
         *        The default maximum duration, specified when registering the workflow type, for executions of this
         *        workflow type. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         *        <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout);

        /**
         * <p>
         * The default task list, specified when registering the workflow type, for decisions tasks scheduled for
         * workflow executions of this type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * 
         * @param defaultTaskList
         *        The default task list, specified when registering the workflow type, for decisions tasks scheduled for
         *        workflow executions of this type. This default can be overridden when starting a workflow execution
         *        using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         *        <a>Decision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * The default task list, specified when registering the workflow type, for decisions tasks scheduled for
         * workflow executions of this type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultTaskList(TaskList)}.
         * 
         * @param defaultTaskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTaskList(TaskList)
         */
        default Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return defaultTaskList(TaskList.builder().applyMutation(defaultTaskList).build());
        }

        /**
         * <p>
         * The default task priority, specified when registering the workflow type, for all decision tasks of this
         * workflow type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority, specified when registering the workflow type, for all decision tasks of
         *        this workflow type. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * The default policy to use for the child workflow executions when a workflow execution of this type is
         * terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
         * action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        The default policy to use for the child workflow executions when a workflow execution of this type is
         *        terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
         *        timeout. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         *        <a>Decision</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(String defaultChildPolicy);

        /**
         * <p>
         * The default policy to use for the child workflow executions when a workflow execution of this type is
         * terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
         * action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        The default policy to use for the child workflow executions when a workflow execution of this type is
         *        terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
         *        timeout. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         *        <a>Decision</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(ChildPolicy defaultChildPolicy);

        /**
         * <p>
         * The default IAM role attached to this workflow type.
         * </p>
         * <note>
         * <p>
         * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role
         * when starting this workflow type, the default Lambda role is attached to the execution. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon
         * .com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param defaultLambdaRole
         *        The default IAM role attached to this workflow type.</p> <note>
         *        <p>
         *        Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an
         *        IAM role when starting this workflow type, the default Lambda role is attached to the execution. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html"
         *        >https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF
         *        Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultLambdaRole(String defaultLambdaRole);
    }

    static final class BuilderImpl implements Builder {
        private String defaultTaskStartToCloseTimeout;

        private String defaultExecutionStartToCloseTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultChildPolicy;

        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowTypeConfiguration model) {
            defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            defaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            defaultTaskList(model.defaultTaskList);
            defaultTaskPriority(model.defaultTaskPriority);
            defaultChildPolicy(model.defaultChildPolicy);
            defaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return defaultExecutionStartToCloseTimeout;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return defaultTaskList != null ? defaultTaskList.toBuilder() : null;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final String getDefaultChildPolicy() {
            return defaultChildPolicy;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy == null ? null : defaultChildPolicy.toString());
            return this;
        }

        public final String getDefaultLambdaRole() {
            return defaultLambdaRole;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        @Override
        public WorkflowTypeConfiguration build() {
            return new WorkflowTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
