/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;

public class ListClosedWorkflowExecutionsPublisher
implements SdkPublisher<ListClosedWorkflowExecutionsResponse> {
    private final SwfAsyncClient client;
    private final ListClosedWorkflowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClosedWorkflowExecutionsPublisher(SwfAsyncClient client, ListClosedWorkflowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClosedWorkflowExecutionsPublisher(SwfAsyncClient client, ListClosedWorkflowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClosedWorkflowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClosedWorkflowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowExecutionInfo> executionInfos() {
        Function<ListClosedWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionInfos() != null) {
                return response.executionInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClosedWorkflowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClosedWorkflowExecutionsResponseFetcher
    implements AsyncPageFetcher<ListClosedWorkflowExecutionsResponse> {
        private ListClosedWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListClosedWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListClosedWorkflowExecutionsResponse> nextPage(ListClosedWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListClosedWorkflowExecutionsPublisher.this.client.listClosedWorkflowExecutions(ListClosedWorkflowExecutionsPublisher.this.firstRequest);
            }
            return ListClosedWorkflowExecutionsPublisher.this.client.listClosedWorkflowExecutions((ListClosedWorkflowExecutionsRequest)((Object)ListClosedWorkflowExecutionsPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

