/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated collection of DomainInfo structures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainsResponse extends SwfResponse implements
        ToCopyableBuilder<ListDomainsResponse.Builder, ListDomainsResponse> {
    private static final SdkField<List<DomainInfo>> DOMAIN_INFOS_FIELD = SdkField
            .<List<DomainInfo>> builder(MarshallingType.LIST)
            .memberName("domainInfos")
            .getter(getter(ListDomainsResponse::domainInfos))
            .setter(setter(Builder::domainInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(ListDomainsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_INFOS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<DomainInfo> domainInfos;

    private final String nextPageToken;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainInfos = builder.domainInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainInfos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainInfos() {
        return domainInfos != null && !(domainInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DomainInfo structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainInfos} method.
     * </p>
     * 
     * @return A list of DomainInfo structures.
     */
    public final List<DomainInfo> domainInfos() {
        return domainInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainInfos() ? domainInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse) obj;
        return hasDomainInfos() == other.hasDomainInfos() && Objects.equals(domainInfos(), other.domainInfos())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainsResponse").add("DomainInfos", hasDomainInfos() ? domainInfos() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainInfos":
            return Optional.ofNullable(clazz.cast(domainInfos()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsResponse, T> g) {
        return obj -> g.apply((ListDomainsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainsResponse> {
        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(Collection<DomainInfo> domainInfos);

        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(DomainInfo... domainInfos);

        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.swf.model.DomainInfo.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.swf.model.DomainInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.swf.model.DomainInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainInfos(List<DomainInfo>)}.
         * 
         * @param domainInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.swf.model.DomainInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainInfos(java.util.Collection<DomainInfo>)
         */
        Builder domainInfos(Consumer<DomainInfo.Builder>... domainInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<DomainInfo> domainInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            super(model);
            domainInfos(model.domainInfos);
            nextPageToken(model.nextPageToken);
        }

        public final List<DomainInfo.Builder> getDomainInfos() {
            List<DomainInfo.Builder> result = DomainInfoListCopier.copyToBuilder(this.domainInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainInfos(Collection<DomainInfo.BuilderImpl> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copyFromBuilder(domainInfos);
        }

        @Override
        public final Builder domainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(DomainInfo... domainInfos) {
            domainInfos(Arrays.asList(domainInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(Consumer<DomainInfo.Builder>... domainInfos) {
            domainInfos(Stream.of(domainInfos).map(c -> DomainInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
