/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChildWorkflowExecutionDecisionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartChildWorkflowExecutionDecisionAttributes> {
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowType").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::workflowType)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::workflowId)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("control").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::control)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::control)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::input)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStartToCloseTimeout").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::executionStartToCloseTimeout)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::executionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskList").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::taskList)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskPriority").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::taskPriority)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::taskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()}).build();
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStartToCloseTimeout").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::taskStartToCloseTimeout)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::taskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childPolicy").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::childPolicyAsString)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagList").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::tagList)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaRole").getter(StartChildWorkflowExecutionDecisionAttributes.getter(StartChildWorkflowExecutionDecisionAttributes::lambdaRole)).setter(StartChildWorkflowExecutionDecisionAttributes.setter(Builder::lambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TYPE_FIELD, WORKFLOW_ID_FIELD, CONTROL_FIELD, INPUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD, CHILD_POLICY_FIELD, TAG_LIST_FIELD, LAMBDA_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowType workflowType;
    private final String workflowId;
    private final String control;
    private final String input;
    private final String executionStartToCloseTimeout;
    private final TaskList taskList;
    private final String taskPriority;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final List<String> tagList;
    private final String lambdaRole;

    private StartChildWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.workflowId = builder.workflowId;
        this.control = builder.control;
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.tagList = builder.tagList;
        this.lambdaRole = builder.lambdaRole;
    }

    public final WorkflowType workflowType() {
        return this.workflowType;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String control() {
        return this.control;
    }

    public final String input() {
        return this.input;
    }

    public final String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public final TaskList taskList() {
        return this.taskList;
    }

    public final String taskPriority() {
        return this.taskPriority;
    }

    public final String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public final ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public final String childPolicyAsString() {
        return this.childPolicy;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<String> tagList() {
        return this.tagList;
    }

    public final String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.control());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChildWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        StartChildWorkflowExecutionDecisionAttributes other = (StartChildWorkflowExecutionDecisionAttributes)obj;
        return Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.control(), other.control()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.executionStartToCloseTimeout(), other.executionStartToCloseTimeout()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.taskPriority(), other.taskPriority()) && Objects.equals(this.taskStartToCloseTimeout(), other.taskStartToCloseTimeout()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.lambdaRole(), other.lambdaRole());
    }

    public final String toString() {
        return ToString.builder((String)"StartChildWorkflowExecutionDecisionAttributes").add("WorkflowType", (Object)this.workflowType()).add("WorkflowId", (Object)this.workflowId()).add("Control", (Object)this.control()).add("Input", (Object)this.input()).add("ExecutionStartToCloseTimeout", (Object)this.executionStartToCloseTimeout()).add("TaskList", (Object)this.taskList()).add("TaskPriority", (Object)this.taskPriority()).add("TaskStartToCloseTimeout", (Object)this.taskStartToCloseTimeout()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("TagList", this.hasTagList() ? this.tagList() : null).add("LambdaRole", (Object)this.lambdaRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "control": {
                return Optional.ofNullable(clazz.cast(this.control()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "executionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionStartToCloseTimeout()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "taskPriority": {
                return Optional.ofNullable(clazz.cast(this.taskPriority()));
            }
            case "taskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.taskStartToCloseTimeout()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "tagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "lambdaRole": {
                return Optional.ofNullable(clazz.cast(this.lambdaRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChildWorkflowExecutionDecisionAttributes, T> g) {
        return obj -> g.apply((StartChildWorkflowExecutionDecisionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowType workflowType;
        private String workflowId;
        private String control;
        private String input;
        private String executionStartToCloseTimeout;
        private TaskList taskList;
        private String taskPriority;
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChildWorkflowExecutionDecisionAttributes model) {
            this.workflowType(model.workflowType);
            this.workflowId(model.workflowId);
            this.control(model.control);
            this.input(model.input);
            this.executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.taskList(model.taskList);
            this.taskPriority(model.taskPriority);
            this.taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.childPolicy(model.childPolicy);
            this.tagList(model.tagList);
            this.lambdaRole(model.lambdaRole);
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        @Override
        @Transient
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        @Transient
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getControl() {
            return this.control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        @Transient
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        @Override
        @Transient
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        @Transient
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        @Override
        @Transient
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        @Override
        @Transient
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        @Override
        @Transient
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        @Transient
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final Collection<String> getTagList() {
            if (this.tagList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagList;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @Override
        @Transient
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        @Transient
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public StartChildWorkflowExecutionDecisionAttributes build() {
            return new StartChildWorkflowExecutionDecisionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartChildWorkflowExecutionDecisionAttributes> {
        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder workflowId(String var1);

        public Builder control(String var1);

        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder taskPriority(String var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder lambdaRole(String var1);
    }
}

