/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalWorkflowExecutionRequest extends SwfRequest implements
        ToCopyableBuilder<SignalWorkflowExecutionRequest.Builder, SignalWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(SignalWorkflowExecutionRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(SignalWorkflowExecutionRequest::workflowId))
            .setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(SignalWorkflowExecutionRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> SIGNAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalName").getter(getter(SignalWorkflowExecutionRequest::signalName))
            .setter(setter(Builder::signalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalName").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(SignalWorkflowExecutionRequest::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            WORKFLOW_ID_FIELD, RUN_ID_FIELD, SIGNAL_NAME_FIELD, INPUT_FIELD));

    private final String domain;

    private final String workflowId;

    private final String runId;

    private final String signalName;

    private final String input;

    private SignalWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.signalName = builder.signalName;
        this.input = builder.input;
    }

    /**
     * <p>
     * The name of the domain containing the workflow execution to signal.
     * </p>
     * 
     * @return The name of the domain containing the workflow execution to signal.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflowId of the workflow execution to signal.
     * </p>
     * 
     * @return The workflowId of the workflow execution to signal.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The runId of the workflow execution to signal.
     * </p>
     * 
     * @return The runId of the workflow execution to signal.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the signal. This name must be meaningful to the target workflow.
     * </p>
     * 
     * @return The name of the signal. This name must be meaningful to the target workflow.
     */
    public final String signalName() {
        return signalName;
    }

    /**
     * <p>
     * Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's history.
     * </p>
     * 
     * @return Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's
     *         history.
     */
    public final String input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(signalName());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalWorkflowExecutionRequest)) {
            return false;
        }
        SignalWorkflowExecutionRequest other = (SignalWorkflowExecutionRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(runId(), other.runId()) && Objects.equals(signalName(), other.signalName())
                && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalWorkflowExecutionRequest").add("Domain", domain()).add("WorkflowId", workflowId())
                .add("RunId", runId()).add("SignalName", signalName()).add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "signalName":
            return Optional.ofNullable(clazz.cast(signalName()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((SignalWorkflowExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, SignalWorkflowExecutionRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow execution to signal.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow execution to signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflowId of the workflow execution to signal.
         * </p>
         * 
         * @param workflowId
         *        The workflowId of the workflow execution to signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The runId of the workflow execution to signal.
         * </p>
         * 
         * @param runId
         *        The runId of the workflow execution to signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the signal. This name must be meaningful to the target workflow.
         * </p>
         * 
         * @param signalName
         *        The name of the signal. This name must be meaningful to the target workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalName(String signalName);

        /**
         * <p>
         * Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's
         * history.
         * </p>
         * 
         * @param input
         *        Data to attach to the <code>WorkflowExecutionSignaled</code> event in the target workflow execution's
         *        history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private String workflowId;

        private String runId;

        private String signalName;

        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalWorkflowExecutionRequest model) {
            super(model);
            domain(model.domain);
            workflowId(model.workflowId);
            runId(model.runId);
            signalName(model.signalName);
            input(model.input);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        @Transient
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        @Transient
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getSignalName() {
            return signalName;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        @Override
        @Transient
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignalWorkflowExecutionRequest build() {
            return new SignalWorkflowExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
