/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>LambdaFunctionScheduled</code> event. It isn't set for other event types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionScheduledEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionScheduledEventAttributes.Builder, LambdaFunctionScheduledEventAttributes> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(LambdaFunctionScheduledEventAttributes::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LambdaFunctionScheduledEventAttributes::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(LambdaFunctionScheduledEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(LambdaFunctionScheduledEventAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startToCloseTimeout").getter(getter(LambdaFunctionScheduledEventAttributes::startToCloseTimeout))
            .setter(setter(Builder::startToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToCloseTimeout").build())
            .build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(LambdaFunctionScheduledEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CONTROL_FIELD, INPUT_FIELD, START_TO_CLOSE_TIMEOUT_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String control;

    private final String input;

    private final String startToCloseTimeout;

    private final Long decisionTaskCompletedEventId;

    private LambdaFunctionScheduledEventAttributes(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.control = builder.control;
        this.input = builder.input;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique ID of the Lambda task.
     * </p>
     * 
     * @return The unique ID of the Lambda task.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * 
     * @return The name of the Lambda function.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the
     * Lambda task.
     * </p>
     * 
     * @return Data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to
     *         the Lambda task.
     */
    public final String control() {
        return control;
    }

    /**
     * <p>
     * The input provided to the Lambda task.
     * </p>
     * 
     * @return The input provided to the Lambda task.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The maximum amount of time a worker can take to process the Lambda task.
     * </p>
     * 
     * @return The maximum amount of time a worker can take to process the Lambda task.
     */
    public final String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
     * scheduling this activity task. To help diagnose issues, use this information to trace back the chain of events
     * leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
     *         scheduling this activity task. To help diagnose issues, use this information to trace back the chain of
     *         events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(startToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionScheduledEventAttributes)) {
            return false;
        }
        LambdaFunctionScheduledEventAttributes other = (LambdaFunctionScheduledEventAttributes) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(control(), other.control()) && Objects.equals(input(), other.input())
                && Objects.equals(startToCloseTimeout(), other.startToCloseTimeout())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionScheduledEventAttributes").add("Id", id()).add("Name", name())
                .add("Control", control()).add("Input", input()).add("StartToCloseTimeout", startToCloseTimeout())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "startToCloseTimeout":
            return Optional.ofNullable(clazz.cast(startToCloseTimeout()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionScheduledEventAttributes, T> g) {
        return obj -> g.apply((LambdaFunctionScheduledEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionScheduledEventAttributes> {
        /**
         * <p>
         * The unique ID of the Lambda task.
         * </p>
         * 
         * @param id
         *        The unique ID of the Lambda task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * 
         * @param name
         *        The name of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the
         * Lambda task.
         * </p>
         * 
         * @param control
         *        Data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent
         *        to the Lambda task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The input provided to the Lambda task.
         * </p>
         * 
         * @param input
         *        The input provided to the Lambda task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum amount of time a worker can take to process the Lambda task.
         * </p>
         * 
         * @param startToCloseTimeout
         *        The maximum amount of time a worker can take to process the Lambda task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
         * scheduling this activity task. To help diagnose issues, use this information to trace back the chain of
         * events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted
         *        in scheduling this activity task. To help diagnose issues, use this information to trace back the
         *        chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String control;

        private String input;

        private String startToCloseTimeout;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionScheduledEventAttributes model) {
            id(model.id);
            name(model.name);
            control(model.control);
            input(model.input);
            startToCloseTimeout(model.startToCloseTimeout);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getControl() {
            return control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        @Transient
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        @Override
        @Transient
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        @Transient
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        @Override
        public LambdaFunctionScheduledEventAttributes build() {
            return new LambdaFunctionScheduledEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
