/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>CancelTimer</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use an <code>Action</code> element to allow or deny permission to call this action.
 * </p>
 * </li>
 * <li>
 * <p>
 * You cannot use an IAM policy to constrain this action's parameters.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
 * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
 * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelTimerDecisionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelTimerDecisionAttributes.Builder, CancelTimerDecisionAttributes> {
    private static final SdkField<String> TIMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timerId").getter(getter(CancelTimerDecisionAttributes::timerId)).setter(setter(Builder::timerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timerId;

    private CancelTimerDecisionAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
    }

    /**
     * <p>
     * The unique ID of the timer to cancel.
     * </p>
     * 
     * @return The unique ID of the timer to cancel.
     */
    public final String timerId() {
        return timerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelTimerDecisionAttributes)) {
            return false;
        }
        CancelTimerDecisionAttributes other = (CancelTimerDecisionAttributes) obj;
        return Objects.equals(timerId(), other.timerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelTimerDecisionAttributes").add("TimerId", timerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timerId":
            return Optional.ofNullable(clazz.cast(timerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelTimerDecisionAttributes, T> g) {
        return obj -> g.apply((CancelTimerDecisionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelTimerDecisionAttributes> {
        /**
         * <p>
         * The unique ID of the timer to cancel.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);
    }

    static final class BuilderImpl implements Builder {
        private String timerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelTimerDecisionAttributes model) {
            timerId(model.timerId);
        }

        public final String getTimerId() {
            return timerId;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        @Override
        @Transient
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        @Override
        public CancelTimerDecisionAttributes build() {
            return new CancelTimerDecisionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
