/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about an activity task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordActivityTaskHeartbeatResponse extends SwfResponse implements
        ToCopyableBuilder<RecordActivityTaskHeartbeatResponse.Builder, RecordActivityTaskHeartbeatResponse> {
    private static final SdkField<Boolean> CANCEL_REQUESTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cancelRequested").getter(getter(RecordActivityTaskHeartbeatResponse::cancelRequested))
            .setter(setter(Builder::cancelRequested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelRequested").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_REQUESTED_FIELD));

    private final Boolean cancelRequested;

    private RecordActivityTaskHeartbeatResponse(BuilderImpl builder) {
        super(builder);
        this.cancelRequested = builder.cancelRequested;
    }

    /**
     * <p>
     * Set to <code>true</code> if cancellation of the task is requested.
     * </p>
     * 
     * @return Set to <code>true</code> if cancellation of the task is requested.
     */
    public final Boolean cancelRequested() {
        return cancelRequested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cancelRequested());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordActivityTaskHeartbeatResponse)) {
            return false;
        }
        RecordActivityTaskHeartbeatResponse other = (RecordActivityTaskHeartbeatResponse) obj;
        return Objects.equals(cancelRequested(), other.cancelRequested());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordActivityTaskHeartbeatResponse").add("CancelRequested", cancelRequested()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cancelRequested":
            return Optional.ofNullable(clazz.cast(cancelRequested()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordActivityTaskHeartbeatResponse, T> g) {
        return obj -> g.apply((RecordActivityTaskHeartbeatResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, RecordActivityTaskHeartbeatResponse> {
        /**
         * <p>
         * Set to <code>true</code> if cancellation of the task is requested.
         * </p>
         * 
         * @param cancelRequested
         *        Set to <code>true</code> if cancellation of the task is requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelRequested(Boolean cancelRequested);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private Boolean cancelRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordActivityTaskHeartbeatResponse model) {
            super(model);
            cancelRequested(model.cancelRequested);
        }

        public final Boolean getCancelRequested() {
            return cancelRequested;
        }

        public final void setCancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
        }

        @Override
        public final Builder cancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            return this;
        }

        @Override
        public RecordActivityTaskHeartbeatResponse build() {
            return new RecordActivityTaskHeartbeatResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
