/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChildWorkflowExecutionTimedOutEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChildWorkflowExecutionTimedOutEventAttributes> {
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowExecution").getter(ChildWorkflowExecutionTimedOutEventAttributes.getter(ChildWorkflowExecutionTimedOutEventAttributes::workflowExecution)).setter(ChildWorkflowExecutionTimedOutEventAttributes.setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()}).build();
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowType").getter(ChildWorkflowExecutionTimedOutEventAttributes.getter(ChildWorkflowExecutionTimedOutEventAttributes::workflowType)).setter(ChildWorkflowExecutionTimedOutEventAttributes.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeoutType").getter(ChildWorkflowExecutionTimedOutEventAttributes.getter(ChildWorkflowExecutionTimedOutEventAttributes::timeoutTypeAsString)).setter(ChildWorkflowExecutionTimedOutEventAttributes.setter(Builder::timeoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()}).build();
    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("initiatedEventId").getter(ChildWorkflowExecutionTimedOutEventAttributes.getter(ChildWorkflowExecutionTimedOutEventAttributes::initiatedEventId)).setter(ChildWorkflowExecutionTimedOutEventAttributes.setter(Builder::initiatedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()}).build();
    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedEventId").getter(ChildWorkflowExecutionTimedOutEventAttributes.getter(ChildWorkflowExecutionTimedOutEventAttributes::startedEventId)).setter(ChildWorkflowExecutionTimedOutEventAttributes.setter(Builder::startedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_EXECUTION_FIELD, WORKFLOW_TYPE_FIELD, TIMEOUT_TYPE_FIELD, INITIATED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowExecution workflowExecution;
    private final WorkflowType workflowType;
    private final String timeoutType;
    private final Long initiatedEventId;
    private final Long startedEventId;

    private ChildWorkflowExecutionTimedOutEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.timeoutType = builder.timeoutType;
        this.initiatedEventId = builder.initiatedEventId;
        this.startedEventId = builder.startedEventId;
    }

    public final WorkflowExecution workflowExecution() {
        return this.workflowExecution;
    }

    public final WorkflowType workflowType() {
        return this.workflowType;
    }

    public final WorkflowExecutionTimeoutType timeoutType() {
        return WorkflowExecutionTimeoutType.fromValue(this.timeoutType);
    }

    public final String timeoutTypeAsString() {
        return this.timeoutType;
    }

    public final Long initiatedEventId() {
        return this.initiatedEventId;
    }

    public final Long startedEventId() {
        return this.startedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedEventId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildWorkflowExecutionTimedOutEventAttributes)) {
            return false;
        }
        ChildWorkflowExecutionTimedOutEventAttributes other = (ChildWorkflowExecutionTimedOutEventAttributes)obj;
        return Objects.equals(this.workflowExecution(), other.workflowExecution()) && Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.timeoutTypeAsString(), other.timeoutTypeAsString()) && Objects.equals(this.initiatedEventId(), other.initiatedEventId()) && Objects.equals(this.startedEventId(), other.startedEventId());
    }

    public final String toString() {
        return ToString.builder((String)"ChildWorkflowExecutionTimedOutEventAttributes").add("WorkflowExecution", (Object)this.workflowExecution()).add("WorkflowType", (Object)this.workflowType()).add("TimeoutType", (Object)this.timeoutTypeAsString()).add("InitiatedEventId", (Object)this.initiatedEventId()).add("StartedEventId", (Object)this.startedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowExecution": {
                return Optional.ofNullable(clazz.cast(this.workflowExecution()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "timeoutType": {
                return Optional.ofNullable(clazz.cast(this.timeoutTypeAsString()));
            }
            case "initiatedEventId": {
                return Optional.ofNullable(clazz.cast(this.initiatedEventId()));
            }
            case "startedEventId": {
                return Optional.ofNullable(clazz.cast(this.startedEventId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChildWorkflowExecutionTimedOutEventAttributes, T> g) {
        return obj -> g.apply((ChildWorkflowExecutionTimedOutEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowExecution workflowExecution;
        private WorkflowType workflowType;
        private String timeoutType;
        private Long initiatedEventId;
        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildWorkflowExecutionTimedOutEventAttributes model) {
            this.workflowExecution(model.workflowExecution);
            this.workflowType(model.workflowType);
            this.timeoutType(model.timeoutType);
            this.initiatedEventId(model.initiatedEventId);
            this.startedEventId(model.startedEventId);
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return this.workflowExecution != null ? this.workflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getTimeoutType() {
            return this.timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(WorkflowExecutionTimeoutType timeoutType) {
            this.timeoutType(timeoutType == null ? null : timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final Long getInitiatedEventId() {
            return this.initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public ChildWorkflowExecutionTimedOutEventAttributes build() {
            return new ChildWorkflowExecutionTimedOutEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChildWorkflowExecutionTimedOutEventAttributes> {
        public Builder workflowExecution(WorkflowExecution var1);

        default public Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return this.workflowExecution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(workflowExecution)).build());
        }

        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder timeoutType(String var1);

        public Builder timeoutType(WorkflowExecutionTimeoutType var1);

        public Builder initiatedEventId(Long var1);

        public Builder startedEventId(Long var1);
    }
}

