/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowTypeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowTypeConfiguration> {
    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultTaskStartToCloseTimeout").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultTaskStartToCloseTimeout)).setter(WorkflowTypeConfiguration.setter(Builder::defaultTaskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultExecutionStartToCloseTimeout").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultExecutionStartToCloseTimeout)).setter(WorkflowTypeConfiguration.setter(Builder::defaultExecutionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultExecutionStartToCloseTimeout").build()}).build();
    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultTaskList").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultTaskList)).setter(WorkflowTypeConfiguration.setter(Builder::defaultTaskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()}).build();
    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultTaskPriority").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultTaskPriority)).setter(WorkflowTypeConfiguration.setter(Builder::defaultTaskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build()}).build();
    private static final SdkField<String> DEFAULT_CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultChildPolicy").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultChildPolicyAsString)).setter(WorkflowTypeConfiguration.setter(Builder::defaultChildPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultChildPolicy").build()}).build();
    private static final SdkField<String> DEFAULT_LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLambdaRole").getter(WorkflowTypeConfiguration.getter(WorkflowTypeConfiguration::defaultLambdaRole)).setter(WorkflowTypeConfiguration.setter(Builder::defaultLambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_LIST_FIELD, DEFAULT_TASK_PRIORITY_FIELD, DEFAULT_CHILD_POLICY_FIELD, DEFAULT_LAMBDA_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String defaultTaskStartToCloseTimeout;
    private final String defaultExecutionStartToCloseTimeout;
    private final TaskList defaultTaskList;
    private final String defaultTaskPriority;
    private final String defaultChildPolicy;
    private final String defaultLambdaRole;

    private WorkflowTypeConfiguration(BuilderImpl builder) {
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    public String defaultTaskStartToCloseTimeout() {
        return this.defaultTaskStartToCloseTimeout;
    }

    public String defaultExecutionStartToCloseTimeout() {
        return this.defaultExecutionStartToCloseTimeout;
    }

    public TaskList defaultTaskList() {
        return this.defaultTaskList;
    }

    public String defaultTaskPriority() {
        return this.defaultTaskPriority;
    }

    public ChildPolicy defaultChildPolicy() {
        return ChildPolicy.fromValue(this.defaultChildPolicy);
    }

    public String defaultChildPolicyAsString() {
        return this.defaultChildPolicy;
    }

    public String defaultLambdaRole() {
        return this.defaultLambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExecutionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultChildPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLambdaRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowTypeConfiguration)) {
            return false;
        }
        WorkflowTypeConfiguration other = (WorkflowTypeConfiguration)obj;
        return Objects.equals(this.defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout()) && Objects.equals(this.defaultExecutionStartToCloseTimeout(), other.defaultExecutionStartToCloseTimeout()) && Objects.equals(this.defaultTaskList(), other.defaultTaskList()) && Objects.equals(this.defaultTaskPriority(), other.defaultTaskPriority()) && Objects.equals(this.defaultChildPolicyAsString(), other.defaultChildPolicyAsString()) && Objects.equals(this.defaultLambdaRole(), other.defaultLambdaRole());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowTypeConfiguration").add("DefaultTaskStartToCloseTimeout", (Object)this.defaultTaskStartToCloseTimeout()).add("DefaultExecutionStartToCloseTimeout", (Object)this.defaultExecutionStartToCloseTimeout()).add("DefaultTaskList", (Object)this.defaultTaskList()).add("DefaultTaskPriority", (Object)this.defaultTaskPriority()).add("DefaultChildPolicy", (Object)this.defaultChildPolicyAsString()).add("DefaultLambdaRole", (Object)this.defaultLambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultTaskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskStartToCloseTimeout()));
            }
            case "defaultExecutionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.defaultExecutionStartToCloseTimeout()));
            }
            case "defaultTaskList": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskList()));
            }
            case "defaultTaskPriority": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskPriority()));
            }
            case "defaultChildPolicy": {
                return Optional.ofNullable(clazz.cast(this.defaultChildPolicyAsString()));
            }
            case "defaultLambdaRole": {
                return Optional.ofNullable(clazz.cast(this.defaultLambdaRole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowTypeConfiguration, T> g) {
        return obj -> g.apply((WorkflowTypeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultTaskStartToCloseTimeout;
        private String defaultExecutionStartToCloseTimeout;
        private TaskList defaultTaskList;
        private String defaultTaskPriority;
        private String defaultChildPolicy;
        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowTypeConfiguration model) {
            this.defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            this.defaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            this.defaultTaskList(model.defaultTaskList);
            this.defaultTaskPriority(model.defaultTaskPriority);
            this.defaultChildPolicy(model.defaultChildPolicy);
            this.defaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return this.defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return this.defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return this.defaultTaskList != null ? this.defaultTaskList.toBuilder() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        public final String getDefaultTaskPriority() {
            return this.defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultChildPolicy() {
            return this.defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy == null ? null : defaultChildPolicy.toString());
            return this;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        public final String getDefaultLambdaRole() {
            return this.defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        public WorkflowTypeConfiguration build() {
            return new WorkflowTypeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowTypeConfiguration> {
        public Builder defaultTaskStartToCloseTimeout(String var1);

        public Builder defaultExecutionStartToCloseTimeout(String var1);

        public Builder defaultTaskList(TaskList var1);

        default public Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return this.defaultTaskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(defaultTaskList)).build());
        }

        public Builder defaultTaskPriority(String var1);

        public Builder defaultChildPolicy(String var1);

        public Builder defaultChildPolicy(ChildPolicy var1);

        public Builder defaultLambdaRole(String var1);
    }
}

