/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionOpenCounts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
    private static final SdkField<Integer> OPEN_ACTIVITY_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("openActivityTasks").getter(WorkflowExecutionOpenCounts.getter(WorkflowExecutionOpenCounts::openActivityTasks)).setter(WorkflowExecutionOpenCounts.setter(Builder::openActivityTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openActivityTasks").build()}).build();
    private static final SdkField<Integer> OPEN_DECISION_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("openDecisionTasks").getter(WorkflowExecutionOpenCounts.getter(WorkflowExecutionOpenCounts::openDecisionTasks)).setter(WorkflowExecutionOpenCounts.setter(Builder::openDecisionTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openDecisionTasks").build()}).build();
    private static final SdkField<Integer> OPEN_TIMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("openTimers").getter(WorkflowExecutionOpenCounts.getter(WorkflowExecutionOpenCounts::openTimers)).setter(WorkflowExecutionOpenCounts.setter(Builder::openTimers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openTimers").build()}).build();
    private static final SdkField<Integer> OPEN_CHILD_WORKFLOW_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("openChildWorkflowExecutions").getter(WorkflowExecutionOpenCounts.getter(WorkflowExecutionOpenCounts::openChildWorkflowExecutions)).setter(WorkflowExecutionOpenCounts.setter(Builder::openChildWorkflowExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openChildWorkflowExecutions").build()}).build();
    private static final SdkField<Integer> OPEN_LAMBDA_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("openLambdaFunctions").getter(WorkflowExecutionOpenCounts.getter(WorkflowExecutionOpenCounts::openLambdaFunctions)).setter(WorkflowExecutionOpenCounts.setter(Builder::openLambdaFunctions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openLambdaFunctions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_ACTIVITY_TASKS_FIELD, OPEN_DECISION_TASKS_FIELD, OPEN_TIMERS_FIELD, OPEN_CHILD_WORKFLOW_EXECUTIONS_FIELD, OPEN_LAMBDA_FUNCTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer openActivityTasks;
    private final Integer openDecisionTasks;
    private final Integer openTimers;
    private final Integer openChildWorkflowExecutions;
    private final Integer openLambdaFunctions;

    private WorkflowExecutionOpenCounts(BuilderImpl builder) {
        this.openActivityTasks = builder.openActivityTasks;
        this.openDecisionTasks = builder.openDecisionTasks;
        this.openTimers = builder.openTimers;
        this.openChildWorkflowExecutions = builder.openChildWorkflowExecutions;
        this.openLambdaFunctions = builder.openLambdaFunctions;
    }

    public Integer openActivityTasks() {
        return this.openActivityTasks;
    }

    public Integer openDecisionTasks() {
        return this.openDecisionTasks;
    }

    public Integer openTimers() {
        return this.openTimers;
    }

    public Integer openChildWorkflowExecutions() {
        return this.openChildWorkflowExecutions;
    }

    public Integer openLambdaFunctions() {
        return this.openLambdaFunctions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openActivityTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.openDecisionTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.openTimers());
        hashCode = 31 * hashCode + Objects.hashCode(this.openChildWorkflowExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.openLambdaFunctions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionOpenCounts)) {
            return false;
        }
        WorkflowExecutionOpenCounts other = (WorkflowExecutionOpenCounts)obj;
        return Objects.equals(this.openActivityTasks(), other.openActivityTasks()) && Objects.equals(this.openDecisionTasks(), other.openDecisionTasks()) && Objects.equals(this.openTimers(), other.openTimers()) && Objects.equals(this.openChildWorkflowExecutions(), other.openChildWorkflowExecutions()) && Objects.equals(this.openLambdaFunctions(), other.openLambdaFunctions());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowExecutionOpenCounts").add("OpenActivityTasks", (Object)this.openActivityTasks()).add("OpenDecisionTasks", (Object)this.openDecisionTasks()).add("OpenTimers", (Object)this.openTimers()).add("OpenChildWorkflowExecutions", (Object)this.openChildWorkflowExecutions()).add("OpenLambdaFunctions", (Object)this.openLambdaFunctions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "openActivityTasks": {
                return Optional.ofNullable(clazz.cast(this.openActivityTasks()));
            }
            case "openDecisionTasks": {
                return Optional.ofNullable(clazz.cast(this.openDecisionTasks()));
            }
            case "openTimers": {
                return Optional.ofNullable(clazz.cast(this.openTimers()));
            }
            case "openChildWorkflowExecutions": {
                return Optional.ofNullable(clazz.cast(this.openChildWorkflowExecutions()));
            }
            case "openLambdaFunctions": {
                return Optional.ofNullable(clazz.cast(this.openLambdaFunctions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionOpenCounts, T> g) {
        return obj -> g.apply((WorkflowExecutionOpenCounts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer openActivityTasks;
        private Integer openDecisionTasks;
        private Integer openTimers;
        private Integer openChildWorkflowExecutions;
        private Integer openLambdaFunctions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionOpenCounts model) {
            this.openActivityTasks(model.openActivityTasks);
            this.openDecisionTasks(model.openDecisionTasks);
            this.openTimers(model.openTimers);
            this.openChildWorkflowExecutions(model.openChildWorkflowExecutions);
            this.openLambdaFunctions(model.openLambdaFunctions);
        }

        public final Integer getOpenActivityTasks() {
            return this.openActivityTasks;
        }

        @Override
        public final Builder openActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
            return this;
        }

        public final void setOpenActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
        }

        public final Integer getOpenDecisionTasks() {
            return this.openDecisionTasks;
        }

        @Override
        public final Builder openDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
            return this;
        }

        public final void setOpenDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
        }

        public final Integer getOpenTimers() {
            return this.openTimers;
        }

        @Override
        public final Builder openTimers(Integer openTimers) {
            this.openTimers = openTimers;
            return this;
        }

        public final void setOpenTimers(Integer openTimers) {
            this.openTimers = openTimers;
        }

        public final Integer getOpenChildWorkflowExecutions() {
            return this.openChildWorkflowExecutions;
        }

        @Override
        public final Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
            return this;
        }

        public final void setOpenChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
        }

        public final Integer getOpenLambdaFunctions() {
            return this.openLambdaFunctions;
        }

        @Override
        public final Builder openLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
            return this;
        }

        public final void setOpenLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
        }

        public WorkflowExecutionOpenCounts build() {
            return new WorkflowExecutionOpenCounts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
        public Builder openActivityTasks(Integer var1);

        public Builder openDecisionTasks(Integer var1);

        public Builder openTimers(Integer var1);

        public Builder openChildWorkflowExecutions(Integer var1);

        public Builder openLambdaFunctions(Integer var1);
    }
}

